% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS.R
\name{seasonder_setSeaSondeRCS_header}
\alias{seasonder_setSeaSondeRCS_header}
\title{Setter for header}
\usage{
seasonder_setSeaSondeRCS_header(seasonder_cs_object, header)
}
\arguments{
\item{seasonder_cs_object}{SeaSondeRCS object}

\item{header}{new value}
}
\value{
A SeaSondeRCS object with updated header.
}
\description{
Setter for header
}
\examples{
# Set sample file paths and create SeaSondeRCS object
cs_file <- system.file("css_data/CSS_TORA_24_04_04_0700.cs", package = "SeaSondeR")
apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
apm_obj <- seasonder_readSeaSondeRAPMFile(apm_file)
cs_obj <- seasonder_createSeaSondeRCS(cs_file, seasonder_apm_object = apm_obj)
# Retrieve and set header
new_header <- seasonder_getSeaSondeRCS_header(cs_obj)
cs_obj <- seasonder_setSeaSondeRCS_header(cs_obj, new_header)
print(seasonder_getSeaSondeRCS_header(cs_obj))
}
\seealso{
\code{\link{seasonder_validateCSHeaderStructure}}
}
