% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semiparMF.R
\name{semiparMF}
\alias{semiparMF}
\title{Fit Semiparametric Spatiotemporal Model with Mixed Frequencies}
\usage{
semiparMF(
  formula,
  data_sf,
  high_freq_data,
  time_col,
  id_col,
  w_matrix = NULL,
  ...
)
}
\arguments{
\item{formula}{A \code{formula} object (e.g., \code{Y ~ Z}). The left-hand side is the response
variable (low frequency). The first predictor on the right-hand side is the parametric
covariate ($Z$) measured at the same frequency.}

\item{data_sf}{An \code{sf} object containing the panel data in long format. Must contain
columns for the response, the parametric covariate, the time index, and the location ID.}

\item{high_freq_data}{A numeric array of dimensions (N x T x K), where:
\itemize{
\item \code{N}: Number of unique spatial locations (must match \code{data_sf}).
\item \code{T}: Number of time points (must match \code{data_sf}).
\item \code{K}: The frequency ratio (e.g., 3 if predictor is monthly and response is quarterly).
}}

\item{time_col}{Character string. The name of the column in \code{data_sf} representing the time index.}

\item{id_col}{Character string. The name of the column in \code{data_sf} representing the location ID.}

\item{w_matrix}{Optional numeric matrix (N x T). A pre-calculated spatial weight or neighborhood variable.
If \code{NULL} (default), a spatial lag of the variable $Z$ is calculated using Queen Contiguity weights.}

\item{...}{Additional arguments passed to the internal backfitting function (e.g., \code{max_iter}, \code{tol}, \code{spar}).}
}
\value{
An object of class \code{semiparMF} containing:
\item{coefficients}{A list of estimated parameters: \code{beta} (parametric covariate effect),
\code{gamma} (neighborhood effect), and \code{rho} (autoregressive parameter).}
\item{nonparam}{A list containing the fitted smoothing spline and the aggregated non-parametric component \code{f_hat}.}
\item{residuals}{Matrix (N x T) of model residuals.}
\item{fitted.values}{Matrix (N x T) of the fitted values (structural part only).}
\item{dims}{Dimensions of the data (N, T).}
\item{meta}{Metadata containing location IDs and time indices.}
\item{history}{Convergence history (MSPE per iteration).}
\item{call}{The function call.}
}
\description{
Fits a spatiotemporal model where the response variable is observed at a lower frequency
(e.g., quarterly) than a non-parametric covariate (e.g., monthly). The model combines
a non-parametric component for the high-frequency predictor, parametric components for
low-frequency predictors and spatial neighborhood effects, and an autoregressive error structure.
}
\examples{
# Simulate data using the package's included simulation function
sim <- simulate_semipar_data(n_side = 4, t_len = 20, k = 3, rho_error = 0.5)

# Fit the model
fit <- semiparMF(
  formula = Y ~ Z, 
  data_sf = sim$data, 
  high_freq_data = sim$X_high,
  time_col = "time_id", 
  id_col = "location_id"
)

# Inspect results
summary(fit)

}
\references{
Malabanan, V. A., Lansangan, J. R. G., & Barrios, E. B. (2022). Semiparametric Spatiotemporal
Model with Mixed Frequencies: With Application in Crop Forecasting. \emph{Science & Engineering Journal},
15(2), 90-107.
}
