% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/assay.R, R/assay5.R, R/seurat.R
\name{AddMetaData}
\alias{AddMetaData}
\alias{SeuratAccess}
\alias{AddMetaData.Assay}
\alias{AddMetaData.Assay5}
\alias{AddMetaData.Seurat}
\title{Add in metadata associated with either cells or features.}
\usage{
AddMetaData(object, metadata, col.name = NULL)

\method{AddMetaData}{Assay}(object, metadata, col.name = NULL)

\method{AddMetaData}{Assay5}(object, metadata, col.name = NULL)

\method{AddMetaData}{Seurat}(object, metadata, col.name = NULL)
}
\arguments{
\item{object}{An object}

\item{metadata}{A vector, list, or data.frame with metadata to add}

\item{col.name}{A name for meta data if not a named list or data.frame}
}
\value{
\code{object} with metadata added
}
\description{
Adds additional data to the object. Can be any piece of information
associated with a cell (examples include read depth, alignment rate,
experimental batch, or subpopulation identity) or feature (ENSG name,
variance). To add cell level information, add to the Seurat object. If adding
feature-level metadata, add to the Assay object (e.g. \code{object[["RNA"]]})
}
\examples{
cluster_letters <- LETTERS[Idents(object = pbmc_small)]
names(cluster_letters) <- colnames(x = pbmc_small)
pbmc_small <- AddMetaData(
  object = pbmc_small,
  metadata = cluster_letters,
  col.name = 'letter.idents'
)
head(x = pbmc_small[[]])

}
\concept{seurat}
