% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fix.fit.R
\name{fix.fit}
\alias{fix.fit}
\title{Estimate the Coefficients of Auto-Regressive (AR) Model by User Specifying}
\usage{
fix.fit(ts, c, b, type, or = 4, m = 500)
}
\arguments{
\item{ts}{ts is the data set which is a time series data typically}

\item{c}{c indicates the number of basis used to estimate (For wavelet, the real number of basis is 2^c.
For Cubic Spline, the real number of basis is c-2+or)}

\item{b}{b is the lag for auto-regressive model}

\item{type}{type indicates which type of basis is used. There are 31 types in this package}

\item{or}{indicates the order of spline and only used in Cspli type, default is 4 which indicates cubic spline}

\item{m}{m indicates the number of points of coefficients to estimate}
}
\value{
A list contains 3 objects, the first is a matrix which contains estimates for each basis used
in OLS, the second is a list contains estimates for coefficients in AR model and the last
is a vector contains residuals
}
\description{
fix.fit() estimates the coefficients of AR model by sieve methods with user specifying.
}
\examples{
set.seed(137)
time.series = c()
n = 1024
v = 25
w = rnorm(n, 0, 1) / v
x_ini = runif(1,0,1)
for(i in 1:n){
  if(i == 1){
    time.series[i] = 0.2 + 0.6*cos(2*pi*(i/n))*x_ini  + w[i] #
  } else{
    time.series[i] = 0.2 + 0.6*cos(2*pi*(i/n))*time.series[i-1] + w[i]
  }
}
res = fix.fit(time.series, c=5, b=1, type = "Legen")
cat(res$ols.coef)
plot.ts(res$ts.coef[[1]])
plot.ts(res$Residuals)
}
