% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/horseshoe.R
\name{select_by_credible_interval}
\alias{select_by_credible_interval}
\title{Select Variables Based on Credible Intervals}
\usage{
select_by_credible_interval(hs_fit, prob = 0.95, verbose = FALSE)
}
\arguments{
\item{hs_fit}{Object returned by \code{\link{fit_horseshoe}}.}

\item{prob}{Probability level for the credible interval. Default 0.95
uses the 95\% credible interval (2.5\% to 97.5\% quantiles).}

\item{verbose}{Logical for messages.}
}
\value{
List with selected variable names and details.
}
\description{
Robust variable selection method using posterior credible intervals.
A variable is selected if its credible interval excludes zero, indicating
a statistically meaningful effect. This method is more robust than
kappa-based selection when the global shrinkage parameter tau collapses.
}
\details{
This function selects variables whose posterior credible interval does not
include zero. This is analogous to checking if a confidence interval
excludes zero in frequentist statistics, but with a Bayesian interpretation.

The method is particularly useful when:
\itemize{
\item The kappa-based selection returns no variables
\item The posterior tau is very small (< 0.05)
\item You want a more interpretable selection criterion
}
}
\examples{
\dontrun{
hs_fit <- fit_horseshoe(y, X, p0 = 5)
selected <- select_by_credible_interval(hs_fit, prob = 0.95, verbose = TRUE)
print(selected$selected)
}

}
\seealso{
\code{\link{select_by_shrinkage}} for kappa-based selection.
}
