% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calSilhouette.R
\name{calSilhouette}
\alias{calSilhouette}
\title{Compute Calculate of All Possible Silhouette Methods}
\usage{
calSilhouette(
  prox_matrix = NULL,
  proximity_type = c("dissimilarity", "similarity"),
  prob_matrix = NULL,
  a = 2,
  print.summary = FALSE,
  clust_fun = NULL,
  ...
)
}
\arguments{
\item{prox_matrix}{A numeric matrix where rows represent observations and columns represent proximity measures (e.g., distances or similarities) to clusters. Typically, this is a membership or dissimilarity matrix from clustering results. If \code{clust_fun} is provided, \code{prox_matrix} should be the name of the matrix component as a string (e.g., if \code{clust_fun = \link[ppclust]{fcm}} from \pkg{ppclust} package the \code{prox_matrix = "d"}).}

\item{proximity_type}{Character string specifying the type of proximity measure in \code{prox_matrix}. Options are \code{"similarity"} (higher values indicate closer proximity) or \code{"dissimilarity"} (lower values indicate closer proximity). Defaults to \code{"dissimilarity"}.}

\item{prob_matrix}{A numeric matrix of cluster membership probabilities, where rows represent
observations and columns represent clusters (depending on \code{prob_type}).
If \code{clust_fun} is provided, \code{prob_matrix} can be given as the name of the matrix
component (e.g., \code{"u"} for the \code{\link[ppclust]{fcm}} function).
Defaults to \code{NULL}.}

\item{a}{Numeric value controlling the fuzzifier or weight scaling in fuzzy silhouette averaging. Higher values increase the emphasis on strong membership differences. Must be positive. Defaults to \code{2}.}

\item{print.summary}{Logical; if \code{TRUE}, prints a summary table of average silhouette widths and sizes for each cluster. Defaults to \code{FALSE}.}

\item{clust_fun}{Optional S3 or S4 function object or function as character string specifying a clustering function that produces the proximity measure matrix. For example, \code{\link[ppclust]{fcm}} or \code{"fcm"}. If provided, \code{prox_matrix} must be the name of the matrix component in the clustering output (e.g., \code{"d"} for \code{\link[ppclust]{fcm}} when \code{proximity_type = "dissimilarity"}). Defaults to \code{NULL}.}

\item{...}{Additional arguments passed to \code{clust_fun}, such as \code{x,centers} for \code{\link[ppclust]{fcm}}.}
}
\value{
A data frame with the following columns:
\describe{
\item{Method}{Character vector of method names}
\item{Crisp_Silhouette}{Numeric vector of crisp (unweighted) average silhouette values}
\item{Fuzzy_Silhouette}{Numeric vector of fuzzy (weighted) average silhouette values (NA if \code{prob_matrix} is not available for the method)}
\item{Median_Silhouette}{Numeric vector of median silhouette values}
}
}
\description{
Computes all possible silhouette indices from available functions in the package and returns a summary data frame comparing crisp, fuzzy, and median silhouette values across different methods.
}
\details{
This function computes all available silhouette methods from the package and returns a comparative summary. The methods included depend on the available input matrices:

\strong{If \code{prox_matrix} is available:}
\itemize{
\item \code{medoid} - Medoid-based silhouette using \code{\link{Silhouette}}
\item \code{pac} - PAC-based silhouette using \code{\link{Silhouette}}
}

\strong{If \code{prob_matrix} is available:}
\itemize{
\item \code{pp_pac} - Posterior probabilities silhouette with PAC method using \code{\link{softSilhouette}}
\item \code{pp_medoid} - Posterior probabilities silhouette with Medoid method using \code{\link{softSilhouette}}
\item \code{nlpp_pac} - Negative log posterior probabilities silhouette with PAC method using \code{\link{softSilhouette}}
\item \code{nlpp_medoid} - Negative log posterior probabilities silhouette with Medoid method using \code{\link{softSilhouette}}
\item \code{pd_pac} - Probability distribution silhouette with PAC method using \code{\link{softSilhouette}}
\item \code{pd_medoid} - Probability distribution silhouette with Medoid method using \code{\link{softSilhouette}}
\item \code{cer} - Certainty-based silhouette using \code{\link{cerSilhouette}}
\item \code{db} - Density-based silhouette using \code{\link{dbSilhouette}}
}

At least one of \code{prox_matrix} or \code{prob_matrix} must be provided.
}
\examples{
if (requireNamespace("ppclust", quietly = TRUE)) {
  # Example with FCM clustering
  library(ppclust)
  data(iris)
  fcm_result <- fcm(iris[, -5], centers = 3)

  # Using matrices directly
  summary_result <- calSilhouette(
    prox_matrix = fcm_result$d,
    prob_matrix = fcm_result$u,
    proximity_type = "dissimilarity",
    print.summary = TRUE
  )
}

if (requireNamespace("ppclust", quietly = TRUE)) {
  # Using clustering function
  summary_result2 <- calSilhouette(
    prox_matrix = "d",
    prob_matrix = "u",
    proximity_type = "dissimilarity",
    clust_fun = ppclust::fcm,
    x = iris[, -5],
    centers = 3,
    print.summary = TRUE
  )
}
}
\seealso{
\code{\link{Silhouette}}, \code{\link{softSilhouette}}, \code{\link{dbSilhouette}}, \code{\link{cerSilhouette}}
}
