% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/max_count_support.R
\name{max_count_support}
\alias{max_count_support}
\title{Calculate Maximum Support Value for Count Variables: Correlation Method 2}
\usage{
max_count_support(k_pois, k_nb, lam, pois_eps = NULL, size, prob, mu = NULL,
  nb_eps = NULL)
}
\arguments{
\item{k_pois}{the number of Poisson variables}

\item{k_nb}{the number of Negative Binomial variables}

\item{lam}{a vector of lambda (> 0) constants for the Poisson variables (see \code{\link[stats]{Poisson}})}

\item{pois_eps}{a vector of length k_pois containing the truncation values (i.e. = rep(0.0001, k_pois); default = NULL)}

\item{size}{a vector of size parameters for the Negative Binomial variables (see \code{\link[stats]{NegBinomial}})}

\item{prob}{a vector of success probability parameters}

\item{mu}{a vector of mean parameters (*Note: either \code{prob} or \code{mu} should be supplied for all Negative Binomial variables,
not a mixture; default = NULL)}

\item{nb_eps}{a vector of length \code{k_nb} containing the truncation values (i.e. = rep(0.0001, k_nb); default = NULL)}
}
\value{
a data.frame with \code{k_pois + k_nb} rows; the column names are:

\code{Distribution} Poisson or Negative Binomial

\code{Number} the variable index

\code{Max} the maximum support value
}
\description{
This function calculates the maximum support value for count variables by extending the method of Barbiero &
    Ferrari (2015, \doi{10.1002/asmb.2072}) to include Negative Binomial variables.  In order for count variables to be treated as ordinal in the
    calculation of the intermediate MVN correlation matrix, their infinite support must be truncated (made finite).  This is
    done by setting the total cumulative probability equal to 1 - a small user-specified value (\code{pois_eps} or \code{nb_eps}.  The
    maximum support value equals the inverse cdf applied to this result.  The values pois_eps and nb_eps may differ for each variable.
    The function is used in \code{\link[SimMultiCorrData]{findintercorr2}} and \code{\link[SimMultiCorrData]{rcorrvar2}}.
    This function would not ordinarily be called by the user.
}
\references{
Barbiero A & Ferrari PA (2015). Simulation of correlated Poisson variables. Applied Stochastic Models in
    Business and Industry, 31: 669-80. \doi{10.1002/asmb.2072}.

Ferrari PA, Barbiero A (2012). Simulating ordinal data, Multivariate Behavioral Research, 47(4): 566-589. \doi{10.1080/00273171.2012.692630}.
}
\seealso{
\code{\link[SimMultiCorrData]{findintercorr2}}, \code{\link[SimMultiCorrData]{rcorrvar2}}
}
\keyword{2}
\keyword{Binomial,}
\keyword{Negative}
\keyword{Poisson,}
\keyword{correlation,}
\keyword{intermediate,}
\keyword{method}
