% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defaults.R
\name{default_set_layers}
\alias{default_set_layers}
\alias{default_intersect_layers}
\alias{default_grid_layers}
\title{Define default layers for individual UpSet components}
\usage{
default_set_layers(
  ...,
  fill = NULL,
  labels = "size",
  f = comma,
  expand = c(0.2, 0),
  hjust = 1.1,
  label_size = 3.5,
  name = "Set Size",
  dry_run = FALSE
)

default_intersect_layers(
  ...,
  fill = NULL,
  labels = "size",
  f = comma,
  expand = c(0, 0.05),
  vjust = -0.5,
  label_size = 3.5,
  name = "Intersection Size",
  dry_run = FALSE
)

default_grid_layers(
  ...,
  colour = NULL,
  fill = NULL,
  light = "grey80",
  dark = "grey23",
  shape = 19,
  size = 4,
  name = NULL,
  dry_run = FALSE
)
}
\arguments{
\item{...}{additional layers to include alongside default layers.
Will be added after the default layers}

\item{fill}{Column to fill set bars by. Can be 'set' or another column within
the main data object}

\item{labels}{Choose either size or prop to label bars with totals or the
proportion of all intersections}

\item{f}{Function for labelling set or intersection sizes sizes}

\item{expand}{Multiplicative axis expansion passed to \code{\link[ggplot2:expansion]{ggplot2::expansion()}}}

\item{hjust, vjust}{Passed to respective elements for simple adjustment of
either set or intersection sizes}

\item{label_size}{Passed to labels for sets and intersections}

\item{name}{Main axis title}

\item{dry_run}{Set as TRUE to view the unevaluated layers which are defined
as the defaults. Additional layers passed through the ellipsis will not be
included as part of a dry_run}

\item{colour}{Primarily used for highlighting points and segments in the
intersections matrix}

\item{light, dark}{default colours for empty intersections (light) and for
both non-empty intersections and segments (dark)}

\item{shape, size}{Point shape/size passed to the intersections matrix}
}
\value{
List of ggplot2 elements
}
\description{
Define and modify default layers for individual UpSet components
}
\details{
These functions define the default layers for inclusion on UpSet plots.

The returned object is a list with a series of layers, scales, themes etc
which represent the default plotting layers for each of the sets,
intersections and intersections matrix (grid) panels.

A series of common arguments have been defined to enable common modifications
without recreating the list from scratch. These include modifying the mapping
to fill, axis expansion to better accommodate labels, labelling functions for
set/intersection sizes, and axis titles.

Additional layers, such as scale_fill_* elements, guides or themes, can be
simply included by passing to the function, without any requirement for
naming, and are handled by the ellipsis.

The entire command used to create default layers can be shown by calling each
function using the argument \code{dry_run = TRUE}.
This can be helpful for creating custom layers, by starting with then
modifying the defaults.

The returned object is a simple list, and are easily modifiable using
simple list operations.
Each list of default layers is described clearly below.
If passing additional scales, themes, layers or guides using the ellipsis,
these additional elements will automatically be placed after the defaults.
Importantly, these will be created as lists, then can be re-ordered using
standard list manipulation.
\subsection{Default Layers For Sets}{\tabular{ll}{
   \strong{ggplot2 element} \tab \strong{Comment} \cr
   \code{aes(y = set)} \tab Sets are placed on the y-axis \cr
   \code{geom_bar(bar_aes)} \tab If \code{fill = NULL}, \code{bar_aes} is the call to \code{aes()} otherwise it is \code{aes(fill = !!sym(fill))}. This object is created internally by \code{default_set_layers()} \cr
   \code{geom_text(aes(x = size, label = f(size)), hjust = hjust, size = label_size)} \tab Adds set totals using the labelling function provided as \code{f}. A data.frame is created when calling \code{simpleUpSet} which summarises set totals as the column \code{size} \cr
   \code{scale_x_reverse(expand = c(expand, 0, 0, 0), name = name, labels = f)} \tab Ensures bars go in reverse order along the x-axis, with the expansion providing room for set totals \cr
   \code{scale_y_discrete(position = "right", name = NULL, labels = NULL)} \tab Tidies up the y-axis with set names \cr
   \code{theme(axis.text.y.right = element_text(hjust = 0.5), axis.ticks.y.right = element_blank(), margins = margin(5.5, 0, 5.5, 5.5))} \tab Ensures margins and tick marks are suitable for the UpSet layout \cr
}

}

\subsection{Default Layers For Intersections}{\tabular{ll}{
   \strong{ggplot2 element} \tab \strong{Comment} \cr
   \code{aes(x = intersect)} \tab Intersections are placed along the x-axis \cr
   \code{geom_bar(bar_aes)} \tab If \code{fill = NULL}, \code{bar_aes} is the call to \code{aes()} otherwise it is \code{aes(fill = !!sym(fill))}. This object is created internally by \code{default_intersect_layers()} \cr
   \code{geom_text(aes(y = size, label = f(size)), vjust = vjust, size = label_size)} \tab Adds intersection totals using the labelling function provided as \code{f}. A data.frame is created when calling \code{simpleUpSet} which summarises intersection totals as the column \code{size} \cr
   \code{scale_x_discrete(name = NULL, labels = NULL)} \tab Tidies up the x-axis, hiding intersection names \cr
   \code{scale_y_continuous(name = name, expand = c(0, 0, expand, 0), labels = f)} \tab Standard y-axis with name provided and with the expansion able to be easily set to accommodate labels \cr
   \code{theme(axis.ticks.x.bottom = element_blank(), margins = margin(5.5, 5.5, 0, 0))} \tab Ensures margins and tick marks are suitable for the UpSet layout \cr
}

}

\subsection{Default Layers For Intersections Matrix (i.e. Grid)}{\tabular{ll}{
   \strong{ggplot2 element} \tab \strong{Comment} \cr
   \code{aes(x = intersect, y = set)} \tab Defines the grid layout to match the sets and intersections panels \cr
   \code{if (!is.null(colour)) geom_point(mapping = points_aes, size = size, shape = shape) else geom_point(mapping = points_aes, size = size, shape = shape, colour = dark)} \tab These points represent the main intersections. In general, colour/fill will only be required if highlighting points and the constant value is removed using an \code{ifelse} statement is colour is set as a mapping aesthetic \cr
   \code{geom_point(size = size, shape = shape, colour = light)} \tab These points represent the background or empty intersections \cr
   \code{if (!is.null(colour)) geom_segment(segment_aes) else geom_segment(segment_aes, colour = dark)} \tab The segments joining intersections, again removing colour if set as an aesthetic mapping \cr
   \code{scale_y_discrete(name = NULL)} \tab Ensures the y-axis matches that of the sets panel \cr
   \code{scale_x_discrete(name = name, labels = NULL)} \tab Ensures the x-axis matches that of the intersection panel, with an optional name \cr
   \code{guides(colour = guide_none())} \tab By default, don't include a legend for any optionally coloured points \cr
   \code{theme(margins = margin(5.5, 5.5, 5.5, 0), axis.text.y = element_text(hjust = 0.5), axis.ticks = element_blank())} \tab Ensures margins, text and tick marks are suitable for the UpSet layout \cr
}

}

\subsection{Panel Internals}{

Internally, the supplied data.frame has the additional columns 'intersect',
'degree' added, along with the optional 'highlight' column.
This object is used to directly create bars using \code{geom_bar()} and as such,
any of the additional columns can be passed to \code{geom_bar()} as mapping
aesthetics, along with all original columns.

For both the sets and intersection totals (i.e. labels), separate tables are
created specifically for printing totals at the top (or left) of each bar,
and these tables are specifically passed to those layers.
Totals are included as 'size' and the proportion of all intersections is
also included as the column 'prop' for both the sets and intersections panel.
Whilst default labels are added using 'size', changing this to 'prop' and
using \code{\link[scales:percent_format]{scales::percent()}} will work and is supported.
}
}
\examples{
# View the un-evaluated list of default layers for the sets
default_set_layers(dry_run = TRUE)

# Create set layers colouring by set name, and hiding the legend
set_list <- default_set_layers(
  fill = "set", scale_fill_brewer(palette = "Set1"), guides(fill = guide_none())
)
sapply(set_list, is)


}
