% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Celltype_Verification.R
\name{Celltype_Verification}
\alias{Celltype_Verification}
\title{Perform cell type verification and generate the validation dotplot}
\usage{
Celltype_Verification(
  seurat_obj,
  SlimR_anno_result,
  assay = "RNA",
  gene_number = 5,
  colour_low = "white",
  colour_high = "navy",
  annotation_col = "Cell_type_SlimR"
)
}
\arguments{
\item{seurat_obj}{A Seurat object containing single-cell data.}

\item{SlimR_anno_result}{A list containing SlimR annotation results with:
Expression_list - List of expression matrices for each cell type.
Prediction_results - Data frame with cluster annotations.}

\item{assay}{Enter the assay used by the Seurat object, such as "RNA". Default
parameters use "assay = 'RNA'".}

\item{gene_number}{Integer specifying number of top genes to select per cell type.}

\item{colour_low}{Color for lowest expression level. (default = "white")}

\item{colour_high}{Color for highest expression level. (default = "navy")}

\item{annotation_col}{Character string specifying the column in meta.data to use for grouping.}
}
\value{
A ggplot object showing expression of top variable genes.
}
\description{
This function performs verification of predicted cell types by selecting
high log2FC and high expression proportion genes and generates and generate the
validation dotplot.
}
\examples{
\dontrun{
Celltype_Verification(seurat_obj = sce,
    SlimR_anno_result = SlimR_anno_result,
    assay = "RNA",
    gene_number = 5,
    colour_low = "white",
    colour_high = "navy",
    annotation_col = "Cell_type_SlimR"
    )
    }

}
\seealso{
Other Section_3_Automated_Annotation: 
\code{\link{Celltype_Annotation}()},
\code{\link{Celltype_Calculate}()},
\code{\link{Parameter_Calculate}()}
}
\concept{Section_3_Automated_Annotation}
