% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sobol4r_sobol_indices.R
\name{sobol_indices}
\alias{sobol_indices}
\title{Sobol Indices for Stochastic Simulators}
\usage{
sobol_indices(
  model,
  design,
  replicates = 1L,
  estimator = c("jansen", "saltelli"),
  keep_samples = FALSE,
  ...
)
}
\arguments{
\item{model}{Function receiving a numeric matrix and returning a numeric
vector of responses. The function may include internal randomness.}

\item{design}{Output of \code{\link[=sobol_design]{sobol_design()}}.}

\item{replicates}{Integer, number of repeated evaluations to average out the
model noise. Defaults to one replicate (deterministic behaviour).}

\item{estimator}{Character string, either \code{"saltelli"} or
\code{"jansen"}. Defaults to \code{"jansen"}.}

\item{keep_samples}{When \code{TRUE}, store all simulated values.}

\item{...}{Further arguments passed to \code{model}.}
}
\value{
An object of class \code{sobol_result} containing the indices,
intermediate estimates, and the Monte Carlo variance.
}
\description{
Estimate first-order and total-order Sobol indices using Monte Carlo
estimators that support noisy outputs via independent replicates.
}
\details{
Two families of estimators are available:
\itemize{
\item \code{"saltelli"}: Saltelli-type estimator with internal centering
of the model outputs before variance and index computation.
\item \code{"jansen"}: Jansen-type estimator based on variances of
output differences, which is numerically stable in many settings.
}
}
\examples{
design <- sobol_design(n = 128, d = 3, quasi = TRUE)
model <- function(x) ishigami_model(x)
result <- sobol_indices(model, design, replicates = 4)
result$data
}
