% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/family-classes.R
\name{get_ST_family_classes}
\alias{get_ST_family_classes}
\title{Get soil family / series differentiae and class names}
\usage{
get_ST_family_classes(
  classname = NULL,
  group = NULL,
  name = NULL,
  chapter = NULL,
  page = NULL,
  multiline_sep = "\\n",
  multiline_col = "criteria"
)
}
\arguments{
\item{classname}{optional filtering vector; levels of \code{ChoiceName} column from NASIS metadata}

\item{group}{optional filtering vector; one or more of: \code{"Mineral Family"}, \code{"Organic Family"}, \code{"Mineral or Organic"}}

\item{name}{optional filtering vector; one or more of: \code{"Mineralogy Classes"}, \code{"Mineralogy Classes Applied Only to Limnic Subgroups"}, \code{"Mineralogy Classes Applied Only to Terric Subgroups"}, \code{"Key to the Particle-Size and Substitute Classes of Mineral Soils"}, \code{"Calcareous and Reaction Classes of Mineral Soils"}, \code{"Reaction Classes for Organic Soils"}, \code{"Soil Moisture Subclasses"}, \code{"Other Family Classes"}, \code{"Soil Temperature Classes"}, \code{"Soil Moisture Regimes"}, \code{"Cation-Exchange Activity Classes"}, \code{"Use of Human-Altered and Human-Transported Material Classes"}}

\item{chapter}{optional filtering vector for chapter number}

\item{page}{optional filtering vector; page number (12th Edition Keys to Soil Taxonomy)}

\item{multiline_sep}{default \code{"\\n"} returns \code{multiline_col} column as a character vector concatenated with \code{"\\n"}. Use \code{NULL} for list}

\item{multiline_col}{character. vector of "multi-line" column names to concatenate. Default: \code{"criteria"}; use \code{NULL} for no concatenation.}
}
\value{
a \emph{data.frame}

a subset of \code{ST_family_classes} \emph{data.frame}
}
\description{
All parameters to this function are optional (default \code{NULL}). If specified, they are used as filters.
}
\details{
This is a wrapper method around the package data set \code{ST_family_classes}.
}
\examples{

# get classes in chapter 17
str(get_ST_family_classes(chapter = 17))

# get classes on page 323
get_ST_family_classes(page = 323)

# get the description for the mesic temperature class from list column
str(get_ST_family_classes(classname = "mesic")$description)

}
\seealso{
\code{ST_family_classes} \code{ST_features} \code{get_ST_features()}
}
