% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{SpaCOAP}
\alias{SpaCOAP}
\title{Fit the SpaCOAP model}
\usage{
SpaCOAP(
  X_count,
  Adj_sp,
  H,
  Z = matrix(1, nrow(X_count), 1),
  offset = rep(0, nrow(X_count)),
  rank_use = 5,
  q = 15,
  epsELBO = 1e-08,
  maxIter = 30,
  verbose = TRUE,
  add_IC_inter = FALSE,
  seed = 1,
  algo = 1
)
}
\arguments{
\item{X_count}{a count matrix, the observed count matrix with shape n-by-p.}

\item{Adj_sp}{a sparse matrix, the weighted adjacency matrix;}

\item{H}{a n-by-d matrix, the covariate matrix with low-rank regression coefficient matrix;}

\item{Z}{an optional matrix, the fixed-dimensional covariate matrix with control variables; default as a full-one column vector if there is no additional covariates.}

\item{offset}{an optional vector, the offset for each unit; default as full-zero vector.}

\item{rank_use}{an optional integer, specify the rank of the regression coefficient matrix; default as 5.}

\item{q}{an optional string, specify the number of factors; default as 15.}

\item{epsELBO}{an optional positive vlaue, tolerance of relative variation rate of the envidence lower bound value, defualt as '1e-8'.}

\item{maxIter}{the maximum iteration of the VEM algorithm. The default is 30.}

\item{verbose}{a logical value, whether output the information in iteration.}

\item{add_IC_inter}{a logical value, add the identifiability condition in iterative algorithm or add it after algorithm converges; default as FALSE.}

\item{seed}{an integer, set the random seed in initialization, default as 1;}

\item{algo}{an optional integer taking value 1 0r 2, select the algorithm used, default as 1, representing variational EM algorithm.}
}
\value{
return a list including the following components:
\itemize{
  \item \code{F} - the predicted factor matrix; 
  \item \code{B} - the estimated loading matrix; 
  \item \code{bbeta} - the estimated low-rank large coefficient matrix; 
  \item \code{alpha0} - the estimated regression coefficient matrix corresponing to Z;
  \item \code{invLambda} - the inverse of the estimated variances of error;
  \item \code{eta} - the estimated spatial autocorrelation parameter;
  \item \code{S} - the approximated posterior covariance for each row of F;
  \item \code{ELBO} -  the ELBO value when algorithm stops;
  \item \code{ELBO_seq} - the sequence of ELBO values.
  \item \code{time_use} - the running time in model fitting of SpaCOAP;
}
}
\description{
Fit the spatial covariate-augmented overdispersed Poisson factor model
}
\details{
None
}
\examples{
width <- 20; height <- 15; p <- 100
d <- 20; k <- 3; q <- 6; r <- 3
datlist <- gendata_spacoap(width=width, height=height, p=p, d=20, k=k, q=q, rank0=r)
fitlist <- SpaCOAP(X_count=datlist$X, Adj_sp = datlist$Adj_sp, 
H= datlist$H, Z = datlist$Z, q=6, rank_use=3)
str(fitlist)
}
\references{
Liu W, Zhong Q. High-dimensional covariate-augmented overdispersed poisson factor model. Biometrics. 2024 Jun;80(2):ujae031.
}
\seealso{
None
}
