% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpaTopic-package.R
\docType{package}
\name{SpaTopic-Package}
\alias{SpaTopic}
\alias{SpaTopic-package}
\alias{SpaTopic-Package}
\title{SpaTopic: Spatial Topic Modeling for Multiplexed Images}
\source{
<https://github.com/xiyupeng/SpaTopic>
}
\description{
SpaTopic is a package for spatial topic modeling of Multiplexed images.
It adapts an approach originally developed for image segmentation in computer vision, 
incorporating spatial information into the flexible design of regions (image partitions, 
analogous to documents in language modeling). We further refined the approach to address 
unique challenges in cellular images and provide an efficient C++ implementation of the 
algorithm in this R package.

Compared to other KNN-based methods (such as KNN-kmeans, the default neighborhood 
analysis in Seurat v5 R package), SpaTopic runs much faster on large-scale image datasets.

The main functions in the 'SpaTopic' package

\itemize{
\item Prepare input   \code{\link{Seurat5obj_to_SpaTopic}}
\item Model Inference \code{\link{SpaTopic_inference}}
\item Print results \code{\link{print.SpaTopic}}
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/xiyupeng/SpaTopic}
  \item Report bugs at \url{https://github.com/xiyupeng/SpaTopic/issues}
}

}
\author{
Xiyu Peng \email{pansypeng124@gmail.com}
}
\keyword{package}
