% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HJBiplot.R
\name{HJBiplot}
\alias{HJBiplot}
\title{HJ Biplot}
\usage{
HJBiplot (X, Transform.Data = 'scale')
}
\arguments{
\item{X}{array_like; \cr
A data frame which provides the data to be analyzed. All the variables must be numeric.}

\item{Transform.Data}{character; \cr
A value indicating whether the columns of X (variables) should be centered or scaled. Options are: "center" that removes the columns means and "scale" that removes the columns means and divide by its standard deviation. Default is "scale".}
}
\value{
\code{HJBiplot} returns a list containing the following components:
\item{eigenvalues}{  array_like; \cr
          vector with the eigenvalues.
          }

\item{explvar}{  array_like; \cr
          an vector containing the proportion of variance explained by the first 1, 2,.,k principal components obtained.
          }

\item{loadings}{  array_like; \cr
          the loadings of the principal components.
          }

\item{coord_ind}{  array_like; \cr
          matrix with the coordinates of individuals.
          }

\item{coord_var}{  array_like; \cr
          matrix with the coordinates of variables.
          }
}
\description{
This function performs the representation of HJ Biplot (Galindo, 1986).
}
\details{
Algorithm used to construct the HJ Biplot. The Biplot is obtained as result of the configuration of markers for individuals and markers for variables in a reference system defined by the factorial axes resulting from the Decomposition in Singular Values (DVS).
}
\examples{
 HJBiplot(mtcars)

}
\references{
\itemize{
 \item Gabriel, K. R. (1971). The Biplot graphic display of matrices with applications to principal components analysis. Biometrika, 58(3), 453-467.
 \item Galindo, M. P. (1986). Una alternativa de representacion simultanea: HJ-Biplot. Questiio, 10(1), 13-23.
}
}
\seealso{
\code{\link{Plot_Biplot}}
}
\author{
Mitzi Cubilla-Montilla, Carlos Torres-Cubilla, Ana Belen Nieto Librero and Purificacion Galindo Villardon
}
