% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpatialGridR.R
\name{SpatialGridR}
\alias{SpatialGridR}
\title{Create a Spatial Grid from the list of longitude and latitude}
\usage{
SpatialGridR(lon_list, lat_list, hemisphere, interval, outputShape)
}
\arguments{
\item{lon_list}{A list of longitudes}

\item{lat_list}{A list of latitudes}

\item{hemisphere}{Either 'north' or 'south'}

\item{interval}{Desired interval for the grid in meter}

\item{outputShape}{Path to the output shapefile}
}
\value{
A spatial grid shapefile
}
\description{
Create a Spatial Grid from the list of longitude and latitude
}
\examples{
\dontrun{
library(SpatGRID)
lon_list<-c(78,78,79,79,78)
lat_list<-c(20,21,21,20,20)
hemisphere <- 'north'
outputShape <- 'C:\\\\path\\\\to\\\\your\\\\data\\\\grid.shp'
interval <- 1000
Spatial_GRID <- SpatialGridR(lon_list, lat_list, hemisphere, interval, outputShape)
}
}
\references{
1. Brus,D.J.(2022). Spatial Sampling with R (1st ed.).Chapman and Hall/CRC.<DOI:10.1201/9781003258940>
2. Hijmans, R. J. (2022). raster: Geographic Data Analysis and Modeling. R package version 3.5-13.
}
