% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DressCrps.R
\name{DressCrps}
\alias{DressCrps}
\title{Calculate the Continuous Ranked Probability Score (CRPS) for a mixture of Normal distributions, for example generated by ensemble dressing}
\usage{
DressCrps(dressed.ens, obs)
}
\arguments{
\item{dressed.ens}{a list with elements `ens`, a N*R matrix representing N time instances of kernel centers, and `ker.wd`, a N*R matrix with corresponding kernel standard deviations. See function `DressEnsemble`}

\item{obs}{a numeric vector of length N with real-valued observations}
}
\value{
numeric vector of length N with the CRPS values
}
\description{
Calculate the Continuous Ranked Probability Score (CRPS) for a mixture of Normal distributions, for example generated by ensemble dressing
}
\examples{
data(eurotempforecast)
dressed.ens <- DressEnsemble(ens)
mean(DressCrps(dressed.ens, obs))
}
\references{
Grimit et al (2006): The continuous ranked probability score for circular variables and its application to mesoscale forecast ensemble verification. Q.J.R. Meteorol. Soc. \doi{10.1256/qj.05.235}
}
\seealso{
EnsCrps, ScoreDiff, SkillScore
}
