% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fun_construct.R
\name{construct}
\alias{construct}
\title{Construction of a \code{Splinets} object}
\usage{
construct(knots, degree, matder, supp = vector(), mthd = "RRM")
}
\arguments{
\item{knots}{\code{n+2} vector, the knots over which the spline is built; 
There should be at least \code{2*degree+4} of knots.}

\item{degree}{integer, the degree of the spline;}

\item{matder}{\code{(n+2)x(degree+1)} matrix, the matrix of derivatives; 
This matrix will be corrected if does not correspond to a proper spline.}

\item{supp}{vector, either empty or two integers representing the single interval support;}

\item{mthd}{string, one of the three methods for correction of the matrix of derivative:
\describe{
 \item{\code{'CRLC'}}{matching mostly the highest derivative,}
 \item{\code{'CRFC'}}{matching mostly the function values at the knots,}
 \item{\code{'RRM'}}{balanced matching between all derivatives;}
}
The default method is \code{'RRM'}, see the paper on the package for further details about the methods.}
}
\value{
A \code{Splinets}-object corresponding to a single spline.
}
\description{
The function constructs a \code{Splinets} object correspond to a single spline (size=1)
from a vector of knots and a matrix of proposed derivatives.
The matrix is tested for its correctness like in \code{is.splinets} and adjusted using one of the implemented methods.
}
\details{
The function constructs a \code{Splinet}-object only over a single interval support. 
Combining with the function \code{lincom} allows to introduce a multi-component support.
}
\section{References}{

Liu, X., Nassar, H., Podg\eqn{\mbox{\'o}}{o}rski, K. "Dyadic diagonalization of positive definite band matrices and efficient B-spline orthogonalization." Journal of Computational and Applied Mathematics (2022) <https://doi.org/10.1016/j.cam.2022.114444>.


Podg\eqn{\mbox{\'o}}{o}rski, K. (2021) 
"\code{Splinets} -- splines through the Taylor expansion, their support sets and orthogonal bases." <arXiv:2102.00733>.

 Nassar, H., Podg\eqn{\mbox{\'o}}{o}rski, K. (2023) "Splinets 1.5.0 -- Periodic Splinets." <arXiv:2302.07552>
}

\examples{
#-------------------------------------------------------------#
#---Building 'Splinets' using different derviative matching---#
#-------------------------------------------------------------#
n=17; k=4
set.seed(5)
xi=sort(runif(n+2)); xi[1]=0; xi[n+1]=1 

#Random matrix of derivatives -- the noise (wild) case to be corrected
S=matrix(rnorm((n+2)*(k+1)),ncol=(k+1))

spl=construct(xi,k,S) #construction of an object, the order of knots is corrected
is.splinets(spl)[[1]] #validation

spl=construct(xi,k,S,mthd='CRFC') #another method of the derivative matching
is.splinets(spl)[[1]]

spl=construct(xi,k,S,mthd='CRLC') #one more method
is.splinets(spl)[[1]]             

#-----------------------------------------------------#
#---------Building not over the full support----------#
#-----------------------------------------------------#
set.seed(5)
n=20; xi=sort(runif(n+2));xi[1]=0;xi[n+2]=1

spl=construct(xi,k,S) #construction of a spline as the 'Splinets' object over the entire range
is.splinets(spl)[[1]] #verification of the conditions

supp=c(3,17) #definition of the single interval support
SS=matrix(rnorm((supp[2]-supp[1]+1)*(k+1)),ncol=(k+1)) #The matrix of derivatives 
                                                       #over the support range
sspl=construct(xi,k,SS,supp=supp) #construction of a spline as the 'Splinets' object 
                                  #with the given support range
is.splinets(sspl)[[1]] #Verification 
sspl@knots
sspl@supp
sspl@der
}
\seealso{
\code{\link{is.splinets}} for diagnostic of \code{Splinets}-objects;
\code{\link{gather}} and \code{\link{subsample}}  for combining and subsampling \code{Splinets}-objects, respectively,
\code{\link{plot,Splinets-method}} for a plotting method for \code{Splinets}-objects;
\code{\link{lincomb}} for combining splines with more complex than a single interval support sets;
}
