% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supercell_GeneGenePlot.R
\name{supercell_GeneGenePlot}
\alias{supercell_GeneGenePlot}
\title{Gene-gene correlation plot}
\usage{
supercell_GeneGenePlot(
  ge,
  gene_x,
  gene_y,
  supercell_size = NULL,
  clusters = NULL,
  color.use = NULL,
  idents = NULL,
  pt.size = 1,
  alpha = 0.9,
  x.max = NULL,
  y.max = NULL,
  same.x.lims = FALSE,
  same.y.lims = FALSE,
  ncol = NULL,
  combine = TRUE,
  sort.by.corr = TRUE
)
}
\arguments{
\item{ge}{a gene expression matrix of super-cells (ncol same as number of super-cells)}

\item{gene_x}{gene or vector of genes (if vector, has to be the same lenght as gene_y)}

\item{gene_y}{gene or vector of genes (if vector, has to be the same lenght as gene_x)}

\item{supercell_size}{a vector with supercell size (ordered the same way as in \code{ge})}

\item{clusters}{a vector with clustering information (ordered the same way as in \code{ge})}

\item{color.use}{colors for idents}

\item{idents}{idents (clusters) to plot (default all)}

\item{pt.size}{point size (if supercells have identical sizes)}

\item{alpha}{transparency}

\item{x.max}{max of x axis}

\item{y.max}{max of y axis}

\item{same.x.lims}{same x axis for all plots}

\item{same.y.lims}{same y axis for all plots}

\item{ncol}{number of colums in combined plot}

\item{combine}{combine plots into a single \link[patchwork]{patchwork}ed ggplot object. If FALSE, return a list of ggplot}

\item{sort.by.corr}{whether to sort plots by absolute value of correlation (fist plot genes with largest (anti-)correlation)}
}
\value{
a list with components
\itemize{
  \item p - is a combined ggplot or list of ggplots if \code{combine = TRUE}
  \item w.cor - weighted correlation between genes
}

a list, where
}
\description{
Plots gene-gene expression and computes their correaltion
}
