% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supercell_estimate_velocity.R
\name{supercell_estimate_velocity}
\alias{supercell_estimate_velocity}
\title{Run RNAvelocity for super-cells (slightly modified from \url{https://github.com/velocyto-team/velocyto.R})
Not yet adjusted for super-cell size (not sample-weighted)}
\usage{
supercell_estimate_velocity(
  emat,
  nmat,
  smat = NULL,
  membership = NULL,
  supercell_size = NULL,
  do.run.avegaring = (ncol(emat) == length(membership)),
  kCells = 10,
  ...
)
}
\arguments{
\item{emat}{spliced (exonic) count matrix (see \url{https://github.com/velocyto-team/velocyto.R})}

\item{nmat}{unspliced (nascent) count matrix (\url{https://github.com/velocyto-team/velocyto.R})}

\item{smat}{optional spanning read matrix (used in offset calculations) (\url{https://github.com/velocyto-team/velocyto.R})}

\item{membership}{supercell membership ('membership' field of \link{SCimplify})}

\item{supercell_size}{a vector with supercell size (if emat and nmat provided at super-cell level)}

\item{do.run.avegaring}{whether to run averaging of emat & nmat (if nmat provided at a single-cell level)}

\item{kCells}{number of k nearest neighbors (NN) to use in slope calculation smoothing (see \url{https://github.com/velocyto-team/velocyto.R})}

\item{...}{other parameters from \url{https://github.com/velocyto-team/velocyto.R}}
}
\value{
results of \url{https://github.com/velocyto-team/velocyto.R} plus metacell size vector
}
\description{
Run RNAvelocity for super-cells (slightly modified from \url{https://github.com/velocyto-team/velocyto.R})
Not yet adjusted for super-cell size (not sample-weighted)
}
