% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EEAaq_time_aggregate.R
\name{EEAaq_time_aggregate}
\alias{EEAaq_time_aggregate}
\title{Time aggregation of an \code{EEAaq_df} class object.}
\usage{
EEAaq_time_aggregate(
  data = NULL,
  frequency = "monthly",
  aggr_fun = c("mean", "min", "max")
)
}
\arguments{
\item{data}{an \code{EEAaq_df} or \code{EEAaq_df_sfc} class object, which is the output of the \code{\link{EEAaq_get_data}} function.}

\item{frequency}{vector containing the time frequency for which to aggregate the \code{data} object.
Admissible values are 'yearly', 'monthly', 'weekly', 'daily' 'hourly'.}

\item{aggr_fun}{character vector containing one or more agregation functions. Admissible values are 'mean', 'median',
'min', 'max', 'sd', 'var',
'quantile_pp' (where pp is a number in the range [0,1], representing the required percentile).}
}
\value{
A \code{EEAaq_taggr_df} or a \code{EEAaq_taggr_df_sfc} class object, which is a tibble containing the
required time aggregation.
}
\description{
\code{EEAaq_time_aggregate} compute a time aggregation of an \code{EEAaq_df} or \code{EEAaq_df_sfc} class object,
based on the specified \code{frequency} and the aggregation functions \code{aggr_fun}.
}
\examples{
\donttest{
### Filter all the stations installed in the city (LAU) of Milano (Italy)
IDstations <- EEAaq_get_stations(byStation = FALSE, complete = FALSE)
`\%>\%` <- dplyr::`\%>\%`
IDstations <- IDstations \%>\%
                dplyr::filter(LAU_NAME == "Milano") \%>\%
                dplyr::pull(AirQualityStationEoICode) \%>\%
                unique()
### Download NO2 measurement for the city of Milano from January 1st to December 31st, 2023
data <- EEAaq_get_data(IDstations = IDstations, pollutants = "NO2",
                       from = "2023-01-01", to = "2023-01-31", verbose = TRUE)

### Monthly aggregation: compute station-specific monthly minimum,
## average, and maximum NO2 concentrations
t_aggr <- EEAaq_time_aggregate(data = data, frequency = "monthly",
                               aggr_fun = c("mean", "min", "max"))

### Weekly aggregation: compute station-specific monthly average
##and standard deviation concentrations
t_aggr <- EEAaq_time_aggregate(data = data, frequency = "weekly",
                               aggr_fun = c("mean", "sd"))
}

}
