% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlayDensities.R
\name{iscamaddnorm}
\alias{iscamaddnorm}
\title{Overlay a Normal Density Function on Histogram}
\usage{
iscamaddnorm(
  x,
  main = "Histogram with normal curve",
  xlab = deparse(substitute(x)),
  bins = NULL
)
}
\arguments{
\item{x}{A numeric vector representing the data to be plotted.}

\item{main}{Optional title for the plot}

\item{xlab}{Optional x-axis label for the plot}

\item{bins}{Optional number of bins for the histogram.}
}
\value{
A histogram of x overlayed with an normal density function.
}
\description{
\code{addnorm} creates a histogram of \code{x} and overlays a normal density function.
}
\examples{
set.seed(0)
x <- rnorm(100)
iscamaddnorm(x)
iscamaddnorm(x, main = "Your Active Title", xlab = "Normal Data", bins = 20)
}
