% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\docType{class}
\name{LeakSplits-class}
\alias{LeakSplits-class}
\alias{LeakFit-class}
\alias{LeakAudit-class}
\title{S4 Classes for bioLeak Pipeline}
\value{
An S4 object of the respective class.
}
\description{
These classes capture splits, model fits, and audit diagnostics produced by
\code{make_split_plan()}, \code{fit_resample()}, and \code{audit_leakage()}.
}
\section{Slots}{

\describe{
\item{\code{mode}}{Splitting mode (e.g., "grouped_cv", "batch_blocked")}

\item{\code{indices}}{List of resampling descriptors (train/test indices when available)}

\item{\code{info}}{Metadata associated with split or fit}

\item{\code{splits}}{A [`LeakSplits`] object used for resampling}

\item{\code{metrics}}{Model performance metrics per resample}

\item{\code{metric_summary}}{Summary of metrics across resamples}

\item{\code{audit}}{Audit information per resample}

\item{\code{predictions}}{List of prediction objects}

\item{\code{preprocess}}{Preprocessing steps used during fitting}

\item{\code{learners}}{Learner definitions used in the pipeline}

\item{\code{outcome}}{Outcome variable name}

\item{\code{task}}{Modeling task name}

\item{\code{feature_names}}{Feature names included in the model}

\item{\code{info}}{Additional metadata about the fit}

\item{\code{fit}}{A [`LeakFit`] object used to generate the audit}

\item{\code{permutation_gap}}{Data frame summarising permutation gaps}

\item{\code{perm_values}}{Numeric vector of permutation-based scores}

\item{\code{batch_assoc}}{Data frame of batch associations}

\item{\code{target_assoc}}{Data frame of feature-wise outcome associations}

\item{\code{duplicates}}{Data frame detailing duplicate records}

\item{\code{trail}}{List capturing audit trail information}
}}

\seealso{
[make_split_plan()], [fit_resample()], [audit_leakage()]

[fit_resample()]

[audit_leakage()], [audit_report()]
}
