% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loo_waic.R
\name{waic.clmstan}
\alias{waic.clmstan}
\title{Widely Applicable Information Criterion for clmstan objects}
\usage{
\method{waic}{clmstan}(x, ...)
}
\arguments{
\item{x}{A \code{clmstan} object returned by \code{\link{clm_stan}}.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
An object of class \code{c("waic", "loo")} containing:
\itemize{
\item \code{estimates}: A matrix with columns \code{Estimate} and \code{SE}
for \code{elpd_waic}, \code{p_waic}, and \code{waic}.
\item \code{pointwise}: A matrix with pointwise contributions.
}
}
\description{
Computes the Widely Applicable Information Criterion (WAIC) for a
fitted cumulative link model.
}
\details{
WAIC is an alternative to LOO-CV that is asymptotically equivalent to
leave-one-out cross-validation. However, LOO-CV with PSIS is generally
preferred because:
\itemize{
\item It provides useful diagnostics (Pareto k values)
\item It is more robust in finite samples
\item It has been shown to be more reliable in practice
}

For most purposes, \code{\link{loo.clmstan}} is recommended over WAIC.
}
\examples{
\dontrun{
fit <- clm_stan(rating ~ temp, data = wine)
waic_result <- waic(fit)
print(waic_result)
}

}
\seealso{
\code{\link{loo.clmstan}} for LOO-CV (recommended),
\code{\link[loo]{waic}} for details on WAIC computation,
\code{\link[loo]{loo_compare}} for model comparison.
}
