% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hist_bary15B.R
\name{histbary15B}
\alias{histbary15B}
\title{Barycenter of Histograms by Benamou et al. (2015)}
\usage{
histbary15B(hists, p = 2, weights = NULL, lambda = NULL, ...)
}
\arguments{
\item{hists}{a length-\eqn{N} list of histograms (\code{"histogram"} object) of same breaks.}

\item{p}{an exponent for the order of the distance (default: 2).}

\item{weights}{a weight of each image; if \code{NULL} (default), uniform weight is set. Otherwise, 
it should be a length-\eqn{N} vector of nonnegative weights.}

\item{lambda}{a regularization parameter; if \code{NULL} (default), a paper's suggestion 
would be taken, or it should be a nonnegative real number.}

\item{...}{extra parameters including \describe{
\item{abstol}{stopping criterion for iterations (default: 1e-8).}
\item{init.vec}{an initial weight vector (default: uniform weight).}
\item{maxiter}{maximum number of iterations (default: 496).}
\item{nthread}{number of threads for OpenMP run (default: 1).}
\item{print.progress}{a logical to show current iteration (default: \code{TRUE}).}
}}
}
\value{
a \code{"histogram"} object of barycenter.
}
\description{
Given multiple histograms represented as \code{"histogram"} S3 objects, compute 
Wasserstein barycenter. We need one requirement that all histograms in an 
input list \code{hists} must have \bold{same breaks}. See the example on how to 
construct a histogram on predefined breaks/bins.
}
\examples{
#----------------------------------------------------------------------
#                      Binned from Two Gaussians
#
# EXAMPLE : Very Small Example for CRAN; just showing how to use it!
#----------------------------------------------------------------------
# GENERATE FROM TWO GAUSSIANS WITH DIFFERENT MEANS
set.seed(100)
x  = stats::rnorm(1000, mean=-4, sd=0.5)
y  = stats::rnorm(1000, mean=+4, sd=0.5)
bk = seq(from=-10, to=10, length.out=20)

# HISTOGRAMS WITH COMMON BREAKS
histxy = list()
histxy[[1]] = hist(x, breaks=bk, plot=FALSE)
histxy[[2]] = hist(y, breaks=bk, plot=FALSE)

# COMPUTE
hh = histbary15B(histxy, maxiter=5)

# VISUALIZE
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,2))
barplot(histxy[[1]]$density, col=rgb(0,0,1,1/4), 
        ylim=c(0, 0.75), main="Two Histograms")
barplot(histxy[[2]]$density, col=rgb(1,0,0,1/4), 
        ylim=c(0, 0.75), add=TRUE)
barplot(hh$density, main="Barycenter",
        ylim=c(0, 0.75))
par(opar)

}
\references{
\insertRef{benamou_2015_IterativeBregmanProjections}{T4transport}
}
\seealso{
\code{\link{fbary15B}}
}
\concept{histogram}
