% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{skr_param_graph}
\alias{skr_param_graph}
\title{skr_param_graph}
\usage{
skr_param_graph(
  skr_param,
  statistics_factor_name,
  statistics_factor_name_breaks = NULL,
  statistics_factor_name_col = NULL,
  slope_distance = CONSTANTS$SKEW_UNIFORM_SLOPE_DISTANCE,
  intercept_distance = CONSTANTS$SKEW_UNIFORM_INTERCEPT_DISTANCE,
  save_skr_param_graph = NULL,
  dpi = 600
)
}
\arguments{
\item{skr_param}{SES of SKR parameters data frame (SES and Significance)}

\item{statistics_factor_name}{column of data use for colors discrimination}

\item{statistics_factor_name_breaks}{vector of factor levels of the
statistics_factor_name, same dimension than statistics_factor_name_col}

\item{statistics_factor_name_col}{vector of colors, same dimension than
statistics_factor_name_breaks}

\item{slope_distance}{slope of the theoretical distribution
law (default: slope = 1 intercept = 1.86 skew-uniform distribution family)}

\item{intercept_distance}{intercept of the theoretical distribution
law (default: slope = 1 intercept = 1.86 skew-uniform distribution family)}

\item{save_skr_param_graph}{The path to save the graph}

\item{dpi}{The dpi number to use when we generate png/jpg graph}
}
\value{
A graph instance
}
\description{
Graph of the parameters computed from the SKR, compared to null model
}
\examples{

\donttest{

  results <- TAD::launch_analysis_tad(
    weights = TAD::AB[, 5:102],
    weights_factor = TAD::AB[, c("Year", "Plot", "Treatment", "Bloc")],
    trait_data = log(TAD::trait[["SLA"]]),
    aggregation_factor_name = c("Year", "Bloc"),
    statistics_factor_name = (statistics_factor_name <- c("Treatment")),
    randomization_number = 100,
    slope_distance = (
      slope_distance <- TAD::CONSTANTS$SKEW_UNIFORM_SLOPE_DISTANCE
    ),
    intercept_distance = (
      intercept_distance <- TAD::CONSTANTS$SKEW_UNIFORM_INTERCEPT_DISTANCE
    )
  )

  # if you want to display the graph
  graph <- TAD::skr_param_graph(
    skr_param = results$ses_skr,
    statistics_factor_name = statistics_factor_name,
    statistics_factor_name_breaks = c("Mown_Unfertilized", "Mown_NPK"),
    statistics_factor_name_col = c("#1A85FF", "#D41159"),
    slope_distance = slope_distance,
    intercept_distance = intercept_distance
  )

  plot(graph)

  output_path <- file.path(tempdir(), "outputs")
  dir.create(output_path)

  # if you want to save the graph as a file
  # either jpg, jpeg, png or svg are
  TAD::skr_param_graph(
    skr_param = results$ses_skr,
    statistics_factor_name = statistics_factor_name,
    statistics_factor_name_breaks = c("Mown_Unfertilized", "Mown_NPK"),
    statistics_factor_name_col = c("#1A85FF", "#D41159"),
    slope_distance = slope_distance,
    intercept_distance = intercept_distance,
    save_skr_param_graph = file.path(output_path, "skr_param_graph.jpeg"),
    dpi = 300
  )

  unlink(output_path, recursive = TRUE, force = TRUE)

}

}
