% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.all.R
\name{make.all}
\alias{make.all}
\alias{makeAll}
\title{Run All TAF Scripts as Needed}
\usage{
make.all(...)
}
\arguments{
\item{...}{passed to \code{\link{make.taf}}.}
}
\value{
Logical vector indicating which scripts were run.
}
\description{
Run core TAF scripts that have changed, or if previous steps were rerun.
}
\note{
TAF scripts that will be run as needed are: \verb{utilities.R},
\verb{data.R}, \verb{model.R}, \verb{output.R}, and \verb{report.R}.

The \verb{model.R} script may also be named \verb{method.R} and is treated in
the same way.
}
\examples{
\dontrun{
make.all()
}

}
\seealso{
\code{\link{source}} runs any R script, \code{\link{source.taf}} is more
convenient for running a TAF script, and \code{\link{source.all}} runs all
TAF scripts.

\code{\link{make}}, \code{\link{make.taf}}, and \code{\link{make.all}} are
similar to the \code{source} functions, except they avoid repeating tasks
that have already been run.

\code{\link{TAF-package}} gives an overview of the package.
}
