% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BCT.r
\name{BCT}
\alias{BCT}
\alias{BCT.rev}
\title{Box Cox Transformation}
\usage{
BCT(x, lambda = NULL, ...)

BCT.rev(x, lambda, ...)
}
\arguments{
\item{x}{A numeric vector or univariate time series of class \code{ts}.}

\item{lambda}{Box-Cox transformation parameter. If \code{NULL},
\code{lambda} is selected using \code{\link[forecast]{BoxCox.lambda}} of the
\code{forecast} package.}

\item{...}{Additional arguments passed to the
\code{\link[forecast]{BoxCox.lambda}} function for \code{BCT()}, and to the
\code{\link[forecast]{InvBoxCox}} function for \code{BCT.rev()}.}
}
\value{
A vector of the same length as x containing the transformed values.
}
\description{
The \code{BCT()} function returns a transformation of the provided time
series using a Box-Cox transformation. \code{BCT.rev()} reverses the
transformation. Wrapper functions for \code{\link[forecast]{BoxCox}} and
\code{\link[forecast]{InvBoxCox}} of the \code{forecast} package,
respectively.
}
\details{
If \code{lambda} is not \code{0}, the Box-Cox transformation is given by
\deqn{f_\lambda(x) =\frac{x^\lambda - 1}{\lambda}} If
\eqn{\lambda=0}, the Box-Cox transformation is given by
\deqn{f_0(x)=\log(x)}.
}
\examples{

data(CATS)
BCT(CATS[,1])

}
\references{
Box, G. E. P. and Cox, D. R. (1964) An analysis of
transformations. \emph{JRSS B} \bold{26} 211--246.
}
\seealso{
\code{\link{DIF}},\code{\link{detrend}}, \code{\link{MAS}},
\code{\link{LT}}, \code{\link{PCT}}
}
\author{
Rebecca Pontes Salles
}
\keyword{Box-Cox}
\keyword{series}
\keyword{time}
\keyword{transform}
