% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tspred.r
\name{workflow}
\alias{workflow}
\alias{workflow.tspred}
\title{Executing a time series prediction process}
\usage{
workflow(obj, ...)

\method{workflow}{tspred}(
  obj,
  data = NULL,
  prep_test = FALSE,
  onestep = obj$one_step,
  eval_fitness = TRUE,
  seed = 1234,
  ...
)
}
\arguments{
\item{obj}{An object of class \code{\link{tspred}} defining a particular time series prediction process.}

\item{...}{Ignored}

\item{data}{See \code{\link{subset.tspred}}}

\item{prep_test}{See \code{\link{preprocess.tspred}}}

\item{onestep}{See \code{\link{predict.tspred}}}

\item{eval_fitness}{See \code{\link{evaluate.tspred}}}

\item{seed}{See \code{\link{set.seed}}}
}
\value{
An object of class \code{tspred} with updated structure containing
all artifacts generated by the execution of the time series prediction process.
}
\description{
\code{workflow} is a generic function for executing the steps of a particular data workflow.
The function invokes particular \emph{methods} which
depend on the class of the first argument.
}
\details{
The function \code{\link{workflow.tspred}} executes a time series prediction process
defined by a \code{\link{tspred}} object. It is a wrapper for the methods \code{\link{subset}}
\code{\link{preprocess}}, \code{\link{train}}, \code{\link{predict}}, \code{\link{postprocess}},
and \code{\link{evaluate}}, which are called in this order. The artifacts generated by
the execution of the time series prediction process are introduced in the structure
of the \code{\link{tspred}} class object in \code{obj}.
}
\examples{
\donttest{
data(CATS)

#Obtaining objects of the processing class
proc1 <- subsetting(test_len=20)
proc2 <- BoxCoxT(lambda=NULL)
proc3 <- WT(level=1, filter="bl14")

#Obtaining objects of the modeling class
modl1 <- ARIMA()

#Obtaining objects of the evaluating class
eval1 <- MSE_eval()

#Defining a time series prediction process
tspred_1 <- tspred(subsetting=proc1,
                   processing=list(BCT=proc2,
                                   WT=proc3),
                   modeling=modl1,
                   evaluating=list(MSE=eval1)
)
summary(tspred_1)

tspred_1 <- workflow(tspred_1,data=CATS[3],onestep=TRUE)
}

}
\seealso{
[tspred()] for defining a particular time series prediction process.
}
\author{
Rebecca Pontes Salles
}
\concept{workflow}
\keyword{evaluate}
\keyword{model}
\keyword{prediction}
\keyword{preprocess}
\keyword{tspred}
\keyword{workflow}
