#' TTR space example data
#'
#' This is an example dataset used for running the TTR.PGM space vignette. It
#' includes both an occurrence data set and data on environmental covariates
#' at the occurrence locations. It is setup so as to demonstrate the use of 
#' the \code{get_input()} function.
#'
#' @docType data
#' @name data_input_space_Terminalia_sericea
#' @usage data(data_input_space_Terminalia_sericea)
#' @format A dataframe with environmental data used to build a TTR input list
#' \describe{
#'   \item{pts.lon}{}
#'   \item{pts.lat}{}
#'   \item{obs}{}
#'   \item{tmax.CHELSA_tasmax_01_1981.2010_V.2.1}{}
#'   \item{tmax.CHELSA_tasmax_02_1981.2010_V.2.1}{}
#'   \item{tmax.CHELSA_tasmax_03_1981.2010_V.2.1}{}
#'   \item{tmax.CHELSA_tasmax_04_1981.2010_V.2.1}{}
#'   \item{tmax.CHELSA_tasmax_05_1981.2010_V.2.1}{}
#'   \item{tmax.CHELSA_tasmax_06_1981.2010_V.2.1}{}
#'   \item{tmax.CHELSA_tasmax_07_1981.2010_V.2.1}{}
#'   \item{tmax.CHELSA_tasmax_08_1981.2010_V.2.1}{}
#'   \item{tmax.CHELSA_tasmax_09_1981.2010_V.2.1}{}
#'   \item{tmax.CHELSA_tasmax_10_1981.2010_V.2.1}{}
#'   \item{tmax.CHELSA_tasmax_11_1981.2010_V.2.1}{}
#'   \item{tmax.CHELSA_tasmax_12_1981.2010_V.2.1}{}
#'   \item{tmin.CHELSA_tasmin_01_1981.2010_V.2.1}{}
#'   \item{tmin.CHELSA_tasmin_02_1981.2010_V.2.1}{}
#'   \item{tmin.CHELSA_tasmin_03_1981.2010_V.2.1}{}
#'   \item{tmin.CHELSA_tasmin_04_1981.2010_V.2.1}{}
#'   \item{tmin.CHELSA_tasmin_05_1981.2010_V.2.1}{}
#'   \item{tmin.CHELSA_tasmin_06_1981.2010_V.2.1}{}
#'   \item{tmin.CHELSA_tasmin_07_1981.2010_V.2.1}{}
#'   \item{tmin.CHELSA_tasmin_08_1981.2010_V.2.1}{}
#'   \item{tmin.CHELSA_tasmin_09_1981.2010_V.2.1}{}
#'   \item{tmin.CHELSA_tasmin_10_1981.2010_V.2.1}{}
#'   \item{tmin.CHELSA_tasmin_11_1981.2010_V.2.1}{}
#'   \item{tmin.CHELSA_tasmin_12_1981.2010_V.2.1}{}
#'   \item{tavg.CHELSA_tas_01_1981.2010_V.2.1}{}
#'   \item{tavg.CHELSA_tas_02_1981.2010_V.2.1}{}
#'   \item{tavg.CHELSA_tas_03_1981.2010_V.2.1}{}
#'   \item{tavg.CHELSA_tas_04_1981.2010_V.2.1}{}
#'   \item{tavg.CHELSA_tas_05_1981.2010_V.2.1}{}
#'   \item{tavg.CHELSA_tas_06_1981.2010_V.2.1}{}
#'   \item{tavg.CHELSA_tas_07_1981.2010_V.2.1}{}
#'   \item{tavg.CHELSA_tas_08_1981.2010_V.2.1}{}
#'   \item{tavg.CHELSA_tas_09_1981.2010_V.2.1}{}
#'   \item{tavg.CHELSA_tas_10_1981.2010_V.2.1}{}
#'   \item{tavg.CHELSA_tas_11_1981.2010_V.2.1}{}
#'   \item{tavg.CHELSA_tas_12_1981.2010_V.2.1}{}
#'   \item{rain.CHELSA_pr_01_1981.2010_V.2.1}{}
#'   \item{rain.CHELSA_pr_02_1981.2010_V.2.1}{}
#'   \item{rain.CHELSA_pr_03_1981.2010_V.2.1}{}
#'   \item{rain.CHELSA_pr_04_1981.2010_V.2.1}{}
#'   \item{rain.CHELSA_pr_05_1981.2010_V.2.1}{}
#'   \item{rain.CHELSA_pr_06_1981.2010_V.2.1}{}
#'   \item{rain.CHELSA_pr_07_1981.2010_V.2.1}{}
#'   \item{rain.CHELSA_pr_08_1981.2010_V.2.1}{}
#'   \item{rain.CHELSA_pr_09_1981.2010_V.2.1}{}
#'   \item{rain.CHELSA_pr_10_1981.2010_V.2.1}{}
#'   \item{rain.CHELSA_pr_11_1981.2010_V.2.1}{}
#'   \item{rain.CHELSA_pr_12_1981.2010_V.2.1}{}
#'   \item{rsds.CHELSA_rsds_1981.2010_01_V.2.1}{}
#'   \item{rsds.CHELSA_rsds_1981.2010_02_V.2.1}{}
#'   \item{rsds.CHELSA_rsds_1981.2010_03_V.2.1}{}
#'   \item{rsds.CHELSA_rsds_1981.2010_04_V.2.1}{}
#'   \item{rsds.CHELSA_rsds_1981.2010_05_V.2.1}{}
#'   \item{rsds.CHELSA_rsds_1981.2010_06_V.2.1}{}
#'   \item{rsds.CHELSA_rsds_1981.2010_07_V.2.1}{}
#'   \item{rsds.CHELSA_rsds_1981.2010_08_V.2.1}{}
#'   \item{rsds.CHELSA_rsds_1981.2010_09_V.2.1}{}
#'   \item{rsds.CHELSA_rsds_1981.2010_10_V.2.1}{}
#'   \item{rsds.CHELSA_rsds_1981.2010_11_V.2.1}{}
#'   \item{rsds.CHELSA_rsds_1981.2010_12_V.2.1}{}
#'   \item{pet.CHELSA_pet_penman_01_1981.2010_V.2.1}{}
#'   \item{pet.CHELSA_pet_penman_02_1981.2010_V.2.1}{}
#'   \item{pet.CHELSA_pet_penman_03_1981.2010_V.2.1}{}
#'   \item{pet.CHELSA_pet_penman_04_1981.2010_V.2.1}{}
#'   \item{pet.CHELSA_pet_penman_05_1981.2010_V.2.1}{}
#'   \item{pet.CHELSA_pet_penman_06_1981.2010_V.2.1}{}
#'   \item{pet.CHELSA_pet_penman_07_1981.2010_V.2.1}{}
#'   \item{pet.CHELSA_pet_penman_08_1981.2010_V.2.1}{}
#'   \item{pet.CHELSA_pet_penman_09_1981.2010_V.2.1}{}
#'   \item{pet.CHELSA_pet_penman_10_1981.2010_V.2.1}{}
#'   \item{pet.CHELSA_pet_penman_11_1981.2010_V.2.1}{}
#'   \item{pet.CHELSA_pet_penman_12_1981.2010_V.2.1}{}
#'   \item{fc}{}
#'   \item{wp}{}
#' }
#' @source See technical description
"data_input_space_Terminalia_sericea"


#' TTR time example data
#'
#' This is an example dataset used for running the TTR.PGM time vignette.
#'
#' @docType data
#' @name data_input_time_SA_BFA_BNP
#' @usage data(data_input_time_SA_BFA_BNP)
#' @format A dataframe with environmental data used to build a TTR input list
#' \describe{
#'   \item{date}{}
#'   \item{tair}{}
#'   \item{tsoil1}{}
#'   \item{tsoil2}{}
#'   \item{tsoil3}{}
#'   \item{tsoil4}{}
#'   \item{srad}{}
#'   \item{moist1}{}
#'   \item{moist2}{}
#'   \item{moist3}{}
#'   \item{moist4}{}
#'   \item{CA}{}
#'   \item{evi}{}
#'   \item{q}{}
#'   \item{sif}{}
#'   \item{osif}{}
#'   \item{msoil}{}
#'   \item{tsoil}{}
#' }
#' @source See technical description
"data_input_time_SA_BFA_BNP"

#' TTR space example data for plotting maps
#'
#' This is an example dataset used for running the TTR.PGM space vignette. It
# #' is the output of running \code{get_input()} on a global 2 degree resolution grid of
#' data points. It is used to demonstrate how to plot a map from a fitted
#' TTR.PGM model.
#'
#' @docType data
#' @name data_map
#' @usage data(data_map)
#' @format A list as produced by the `get_input()` function.
#' @source This dataset was generated by running `get_input()` on a global grid 
#' of environmental data at 2-degree resolution. 
"data_map"






