#include "ttr_environment.hpp"

namespace ttr{
environment::environment(
  const arma::cube& timeseries,
  //const arma::mat& timeinvariant,
  const List& options,
  const NumericVector& globals_in)
{
  globals = ParameterVector<Global>(globals_in);
  steps = as<IntegerVector>(options["steps"]);
  auto photos_in = as<IntegerVector>(options["photo"]);
  photos = std::vector<PhotoType>(photos_in.length());
  for(unsigned int i = 0; i < photos_in.length(); i++){
    auto p = enum_cast<PhotoType>(photos_in[i]-1);
    if(p){
      photos[i] = p.value();
    }
    else{
      Rcerr << "Unknown photo type" << std::endl;
    }
  }

  ntimeout = steps.length();
  nsteps = steps[steps.length() - 1];
  nsites = timeseries.n_slices;
  nspecies = as<StringVector>(options["species"]).length();
  ndata = timeseries.n_cols;

  //load variant option
  auto maybe_var = enum_cast<TTRVariant>(as<StringVector>(options["ve"])[0]);
  if(maybe_var){
    var = maybe_var.value();
  }
  else{
    Rcerr << "Unknown variant" << std::endl;
  }

  initial_mass = as<double>(options["initial_mass"]);
  initial_mass_par = as<bool>(options["initial_mass_par"]);
  pe = as<bool>(options["pe"]);
  pe_scale = as<double>(options["pe_scale"]);
  nspecies = as<StringVector>(options["species"]).size();
}
}
