% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EMV.R
\name{EMV}
\alias{EMV}
\title{Arms' Ease of Movement Value}
\usage{
EMV(HL, volume, n = 9, maType, vol.divisor = 10000, ...)
}
\arguments{
\item{HL}{Object that is coercible to xts or matrix and contains High-Low
prices.}

\item{volume}{Vector or matrix of volume observations corresponding to the
\code{HL} object.}

\item{n}{Number of periods for moving average.}

\item{maType}{A function or a string naming the function to be called.}

\item{vol.divisor}{An increment to make the results larger and easier to work
with.}

\item{\dots}{Other arguments to be passed to the \code{maType} function.}
}
\value{
A object of the same class as \code{HL} and \code{volume} or a matrix
(if \code{try.xts} fails) containing the columns:
 \describe{
  \item{ emv }{ The ease of movement values. }
  \item{ maEMV }{ The smoothed (as specified by \code{ma}) ease of movement values. }
 }
}
\description{
Arms' Ease of Movement Value (EMV) emphasizes days where the security moves
easily and minimizes days where the security does not move easily.  Developed
by Richard W. Arms, Jr.
}
\details{
The EMV is calculated by dividing the midpoint ([high + low]/2) move by the
'Box Ratio' (volume divided by the high minus low).
}
\note{
A buy/sell signal is generated when the EMV crosses above/below zero.
When the EMV hovers around zero, there are small price movements and/or high
volume, and the price is not moving easily.
}
\examples{

 data(ttrc)
 emv <- EMV(ttrc[,c("High","Low")], ttrc[,"Volume"])

}
\references{
The following site(s) were used to code/document this
indicator:\cr \url{https://www.fmlabs.com/reference/ArmsEMV.htm}\cr
\url{https://www.metastock.com/Customer/Resources/TAAZ/?p=51}\cr
\url{https://www.linnsoft.com/techind/arms-ease-movement}\cr
}
\seealso{
See \code{\link{EMA}}, \code{\link{SMA}}, etc. for moving average
options; and note Warning section.
}
\author{
Joshua Ulrich
}
\keyword{ts}
