% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotcoresets.R
\name{plotcoresets}
\alias{plotcoresets}
\title{Plot multiple core sets}
\usage{
plotcoresets(games, binary = FALSE, imputations = TRUE)
}
\arguments{
\item{games}{A matrix in which each row is a characteristic function.}

\item{binary}{A logical value. By default, \code{binary=FALSE}. Should be set to \code{TRUE} if the characteristic functions in \code{games} are introduced in binary order instead of lexicographic order.}

\item{imputations}{A logical value. By default, \code{imputations=TRUE}.
When set to \code{imputations=FALSE}, the sets of imputations are not drawn.}
}
\value{
A plot of the given core sets.
}
\description{
Given multiple games with two, three or four players, this function draws in a single plot their projected core sets and sets of imputations.
}
\details{
The core of a game \eqn{v\in G^N} is the set of all its stable imputations:
\deqn{C(v)=\{x\in\mathbb{R}^n : x(N)=v(N), x(S)\ge v(S)\ \forall S \in 2^N\},}
where \eqn{x(S)=\sum_{i\in S} x_i}.
}
\examples{
# Plotting the core and the least core of a game:
v <- c(0,0,0,0,10,40,30,60,10,20,90,90,90,130,160)
vt <- leastcore(v)$vt
plotcoresets(games = rbind(v,vt), imputations = FALSE)
}
\seealso{
\link{plotcoreset}
}
