% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symmetrycheck.R
\name{symmetrycheck}
\alias{symmetrycheck}
\title{Symmetry check}
\usage{
symmetrycheck(v, i, j, binary = FALSE, tol = 100 * .Machine$double.eps)
}
\arguments{
\item{v}{A characteristic function, as a vector.}

\item{i}{The position of an individual coalition, as an integer.}

\item{j}{The position of another individual coalition, as an integer.}

\item{binary}{A logical value. By default, \code{binary=FALSE}. Should be set to \code{TRUE} if \code{v}, \code{i} and \code{j} are introduced in binary order instead of lexicographic order.}

\item{tol}{A tolerance parameter, as a non-negative number.\cr
By default, \code{tol=100*.Machine$double.eps}.}
}
\value{
\code{TRUE} if \code{i} and \code{j} are symmetric in \code{v}, \code{FALSE} otherwise.
}
\description{
Given a game and two players, this function checks if those are symmetric players.
}
\details{
Let \eqn{v\in G^N}. Players \eqn{i,j \in N} are symmetric in \eqn{v} if,
for each \eqn{S \subset N} with \eqn{i,j \in S}, \eqn{v(S \setminus \{i\}) = v(S \setminus \{j\})}.
}
\examples{
symmetrycheck(c(13,13,0,0,58,58,0),1,2) # players 1 and 2 are symmetric
}
