% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/additivecheck.R
\name{additivecheck}
\alias{additivecheck}
\title{Additive check}
\usage{
additivecheck(v, binary = FALSE, instance = FALSE)
}
\arguments{
\item{v}{A characteristic function, as a vector.}

\item{binary}{A logical value. By default, \code{binary=FALSE}. Should be set to \code{TRUE} if \code{v} is introduced in binary order instead of lexicographic order.}

\item{instance}{A logical value. By default, \code{instance=FALSE}.}
}
\value{
\code{TRUE} if the game defined by \code{v} is additive, \code{FALSE} otherwise. If \code{instance=TRUE} and the game is not additive, the position (binary order position if \code{binary=TRUE}; lexicographic order position otherwise) of a coalition for which additivity is violated is also returned.
}
\description{
This function checks if the given game is additive.
}
\details{
A game \eqn{v\in G^N} is additive if \eqn{v(S)=\sum_{i\in S}v(i)} for all \eqn{S\in 2^N}.
}
\examples{
v <- c(1, 5, 40, 100, 6, 41, 101, 45, 105, 140, 46, 106, 141, 145, 146)
additivecheck(v)
additivecheck(v, binary = TRUE, instance = TRUE)
}
\seealso{
\link{additivegame}, \link{superadditivecheck}
}
