% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getpermutationnumber.R
\name{getpermutationnumber}
\alias{getpermutationnumber}
\title{Get permutation number}
\usage{
getpermutationnumber(permutation)
}
\arguments{
\item{permutation}{A permutation, as a vector.}
}
\value{
The position of the permutation according to the Lehmer code order, as an integer.
}
\description{
Given a permutation, this function returns its position in the Lehmer code order.
}
\details{
The Lehmer code makes use of the fact that there are \eqn{n!} permutations of a sequence of \eqn{n} numbers.
If a permutation \eqn{\sigma} is specified by the sequence \eqn{(\sigma_{i})_{i=1}^{n}}, its Lehmer code is the
sequence \eqn{L(\sigma)=(L(\sigma)_{i})_{i=1}^{n}}, where \eqn{L(\sigma)_i=|\{j>i:\sigma_j<\sigma_i\}|}.

The position of permutation \eqn{\sigma} according to the Lehmer code order is
\deqn{L_{\sigma}=1 + \sum_{i=1}^{n} (n-i)! L(\sigma)_i}.
}
\examples{
getpermutationnumber(c(1, 2, 5, 4, 3))
}
\seealso{
\link{getpermutation}
}
