% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minimalrightsvector.R
\name{minimalrightsvector}
\alias{minimalrightsvector}
\title{Minimal rights vector}
\usage{
minimalrightsvector(v, binary = FALSE)
}
\arguments{
\item{v}{A characteristic function, as a vector.}

\item{binary}{A logical value. By default, \code{binary=FALSE}. Should be set to \code{TRUE} if \code{v} is introduced in binary order instead of lexicographic order.}
}
\value{
The minimal rights vector.
}
\description{
This function computes the minimal rights vector of a game.
}
\details{
Given \eqn{v\in G^N}, the utopia payoff of player \eqn{i\in N} is defined as
\eqn{M_i(N,v)=v(N)-v(N\backslash i)}.

The minimal right of player \eqn{i\in N} is defined as \eqn{m_i(N,v)=\max_{S:i\in S}(v(S)-\sum_{j\in S\backslash i}M_j(N,v))}.
}
\examples{
v <- c(0, 0, 0, 1, 1, 1, 2)
minimalrightsvector(v)
convexcheck(v)
minimalrightsvector(v) == c(v[1],v[2],v[3])
w <- c(0,0,0,4,7,6,10)
convexcheck(w)
minimalrightsvector(w) == c(w[1],w[2],w[3])
}
\seealso{
\link{utopiapayoffsvector}
}
