% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solidarityvalue.R
\name{solidarityvalue}
\alias{solidarityvalue}
\title{Solidarity value}
\usage{
solidarityvalue(v, binary = FALSE, amc = FALSE)
}
\arguments{
\item{v}{A characteristic function, as a vector.}

\item{binary}{A logical value. By default, \code{binary=FALSE}. Should be set to \code{TRUE} if \code{v} is introduced in binary order instead of lexicographic order.}

\item{amc}{A logical value. By default, \code{amc=FALSE}. If set to \code{TRUE}, the average marginal contributions are also returned.}
}
\value{
The solidarity value of the game, as a vector. If \code{amc=TRUE}, a vector (in binary order if \code{binary=TRUE} and in lexicographic order otherwise) containing the average marginal contribution to each coalition is also returned.
}
\description{
Given a game, this function computes its solidarity value.
}
\details{
Given \eqn{v\in G^N}, the average marginal contribution to coalition \eqn{S\in 2^N} is defined as
\deqn{AMC(S)=\frac{1}{|S|}\sum_{k\in S}(v(S)-v(S\backslash \{k\})).}
The solidarity value of each player \eqn{i \in N} can be defined as
\deqn{\phi_i(v)=\sum_{S : i\in S}\frac{(n-|S|)!(|S|-1)!}{|N|!}AMC(S).}
}
\examples{
solidarityvalue(c(0,0,0,1,1,1,2), binary=TRUE)
solidarityvalue(bin2lex(c(0,0,1,2,5,5,7)))
solidarityvalue(bin2lex(c(0,0,2,7,9,10,12,9,11,12,14,19,21,22,24)), amc=TRUE)
}
\references{
Nowak, A. S. & Radzik, T. (1994). A solidarity value for n-person transferable utility games. \emph{International Journal of Game Theory}, 23, 43-48.
}
\seealso{
\link{shapleyvalue}
}
