% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_functions.R
\name{epanechnikov_kernel}
\alias{epanechnikov_kernel}
\title{Epanechnikov Kernel Function}
\usage{
epanechnikov_kernel(u)
}
\arguments{
\item{u}{A numeric vector of points at which the kernel is evaluated.}
}
\value{
A numeric vector of kernel values corresponding to each input \code{u}.
}
\description{
This function computes the value of the Epanechnikov kernel for a given input \eqn{u}.
The Epanechnikov kernel is a popular choice in kernel density estimation due to its optimal
properties in minimizing mean integrated squared error.
}
\details{
The Epanechnikov kernel is defined as:
\deqn{
K(u) = \begin{cases}
\frac{3}{4}(1 - u^2) & \text{if } |u| \leq 1, \\
0 & \text{otherwise}.
\end{cases}
}

This function applies the above formula to each element of the input vector \code{u}.
}
\examples{
# Define a range of u values
u_values <- seq(-1.5, 1.5, by = 0.1)

# Compute Epanechnikov kernel values
kernel_values <- epanechnikov_kernel(u_values)

}
