% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basicfcts_TS_extended.R
\name{pKRTS}
\alias{pKRTS}
\title{Cumulative probability distribution function of the Kim-Rachev tempered
stable (KRTS) distribution}
\usage{
pKRTS(
  q,
  alpha = NULL,
  kp = NULL,
  km = NULL,
  rp = NULL,
  rm = NULL,
  pp = NULL,
  pm = NULL,
  mu = NULL,
  theta = NULL,
  dens_method = "FFT",
  a = -40,
  b = 40,
  nf = 2048,
  ...
)
}
\arguments{
\item{q}{A vector of real numbers where the CF is evaluated.}

\item{alpha}{Stability parameter. A real number between 0 and 2.}

\item{kp, km, rp, rm}{Parameter of KR-distribution. A real number \code{>0}.}

\item{pp, pm}{Parameter of KR-distribution. A real number \code{>-alpha}.}

\item{mu}{A location parameter, any real number.}

\item{theta}{Parameters stacked as a vector.}

\item{dens_method}{Algorithm for numerical evaluation. Currently, only \code{
"FFT"} available.}

\item{a}{Starting point of FFT, if \code{dens_method == "FFT"}. -40
by default.}

\item{b}{Ending point of FFT, if \code{dens_method == "FFT"}. 40
by default.}

\item{nf}{Pieces the transformation is divided in. Limited to power-of-two
size.}

\item{...}{Possibility to modify \code{stats::integrate()}.}
}
\value{
As \code{q} is a numeric vector, the return value is also a numeric
vector of probabilities.
}
\description{
The cumulative probability distribution function (CDF) of the Kim-Rachev
tempered stable distribution.
}
\details{
\code{theta} denotes the parameter vector \code{(alpha, kp, km,
rp, rm, pp. pm, mu))}. Either provide the parameters individually OR
provide \code{theta}.
The function integrates the PDF numerically with \code{integrate()}.
}
\seealso{
See also the \code{\link[=dKRTS]{dKRTS()}} density-function.
}
