% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Listwise.r
\name{Listwise}
\alias{Listwise}
\title{Listwise Deletion (LW)}
\usage{
Listwise(test.data, Mvalue = "NA")
}
\arguments{
\item{test.data}{Test data set (a data frame or a matrix) containing missing responses. 
Missing values are coded as NA or other values (e.g., 8, 9).}

\item{Mvalue}{Missing response indicators in the data (e.g. "NA", "8", "9", etc.). Mvalue="NA" by default.}
}
\value{
A data frame with no missing responses.
}
\description{
This function deletes examinees who report missing responses (see De Ayala et al. 2001)
<doi:10.1111/j.1745-3984.2001.tb01124.x>.
}
\examples{
 
        Listwise(test.data, Mvalue="NA")
}
\references{
{
 De Ayala, R. J., Plake, B. S., & Impara, J. C. (2001). 
"The impact of omitted responses on the accuracy of ability estimation in item response theory."
 Journal of Educational Measurement, 38(3), 213–234. doi:10.1111/j.1745-3984.2001.tb01124.x. 
}
}
