% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sign2.R
\name{sign2}
\alias{sign2}
\title{Sign of Difference of Two Objects}
\usage{
sign2(
  e1,
  e2,
  name1 = substitute(e1),
  name2 = substitute(e2),
  na.detail = TRUE,
  ...
)
}
\arguments{
\item{e1, e2}{two R objects, must be both
\link[base]{numeric} \link[base]{vector}s,
or \link[base]{ordered} \link[base]{factor}s with the same \link[base]{levels}}

\item{name1, name2}{two \link[base]{language} objects, or \link[base]{character} scalars}

\item{na.detail}{\link[base]{logical} scalar,
whether to provide the missingness details of \code{e1} and \code{e2}.
Default \code{TRUE}.}

\item{...}{additional parameters, currently not in use}
}
\value{
Function \link{sign2} returns \link[base]{character} \link[base]{vector} when \code{na.detail = TRUE}, or
\link[base]{ordered} \link[base]{factor} when \code{na.detail = FALSE}.
}
\description{
..
}
\details{
Function \link{sign2} extends \link[base]{sign} in the following ways
\itemize{
\item {two \link[base]{ordered} \link[base]{factor}s can be compared;}
\item {(detailed) information on missingness are provided.}
}
}
\examples{
lv = letters[c(1,3,2)]
x0 = letters[1:3]
x = ordered(sample(x0, size = 100, replace = TRUE), levels = lv)
y = ordered(sample(x0, size = 50, replace = TRUE), levels = lv)
x < y # base R ok
pmax(x, y) # base R okay
pmin(x, y) # base R okay
x[c(1,3)] = NA
y[c(3,5)] = NA
table(sign(unclass(y) - unclass(x)))
table(sign2(x, y))
table(sign2(x, y, na.detail = FALSE), useNA = 'always')

}
