% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_frailty.R
\name{post_frailty_internal}
\alias{post_frailty_internal}
\title{Posterior Frailty Estimates and Variances for the 'Adapted Paik et Al.'s Model'}
\usage{
post_frailty_internal(
  optimal_params,
  dataset,
  time_to_event,
  centre,
  time_axis
)
}
\arguments{
\item{optimal_params}{Optimal parameters estimated by maximizing the log-likelihood function, through the constraint
multi-dimensional optmization method.}

\item{dataset}{Dataset containing all the covariates/regressors.}

\item{time_to_event}{Time-instant, in the follow-up, in which an individual faces the event or fails.
If an individual does not face the event in the follow-up, then the time-instant must assume a default value.}

\item{centre}{Individual group/cluster membership.}

\item{time_axis}{Temporal domain.}
}
\value{
S3 object of class 'PF.AdPaik' composed of two elements of different class:
\itemize{
\item PosteriorFrailtyEst: S3 object of class 'PFE.AdPaik'.
\item PosteriorFrailtyVar: S3 object of class 'PFV.AdPaik'.
}
}
\description{
Posterior Frailty Estimates and Variances for the 'Adapted Paik et Al.'s Model'
}
\keyword{internal}
