% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/07-visualization.R
\name{create_fishery_dashboard}
\alias{create_fishery_dashboard}
\title{Create fishery dashboard}
\usage{
create_fishery_dashboard(
  data,
  date_col = NULL,
  length_cols = NULL,
  a = 1e-04,
  b = 2.984,
  latitude_col = NULL,
  longitude_col = NULL,
  catch_col = NULL,
  juvenile_col = NULL,
  map_xlim = c(-85, -70),
  map_ylim = c(-20, 0),
  color_palette = NULL,
  date_breaks = NULL,
  sort_comparison = FALSE,
  comparison_title = NULL,
  catch_title = NULL,
  map_title = NULL,
  trend_title = NULL
)
}
\arguments{
\item{data}{Data frame with complete fishery data.}

\item{date_col}{Date column name. If NULL, auto-detect.}

\item{length_cols}{Length frequency column names. If NULL, auto-detect.}

\item{a}{Length-weight coefficient.}

\item{b}{Length-weight exponent.}

\item{latitude_col}{Latitude column name. If NULL, auto-detect.}

\item{longitude_col}{Longitude column name. If NULL, auto-detect.}

\item{catch_col}{Catch column name. If NULL, auto-detect.}

\item{juvenile_col}{Juvenile percentage column name. If NULL, auto-detect.}

\item{map_xlim}{Map longitude limits.}

\item{map_ylim}{Map latitude limits.}

\item{color_palette}{Custom color palette.}

\item{date_breaks}{Date axis breaks.}

\item{sort_comparison}{Sort comparison plot.}

\item{comparison_title}{Comparison plot title.}

\item{catch_title}{Catch plot title.}

\item{map_title}{Map plot title.}

\item{trend_title}{Trend plot title.}
}
\value{
List with individual plots and combined dashboard (if patchwork available).
}
\description{
Generates a comprehensive dashboard for fishery analysis including juvenile analysis,
catch trends, spatial distribution, and summary statistics. This function consolidates
all dashboard functionality.
}
\examples{
\dontrun{
dashboard <- create_fishery_dashboard(
  data = complete_fishery_data,
  date_col = "date",
  length_cols = paste0("length_", seq(8, 15, 0.5)),
  catch_col = "total_catch",
  latitude_col = "latitude",
  longitude_col = "longitude"
)

dashboard$comparison
dashboard$catch_trends
dashboard$spatial_map
dashboard$trends
dashboard$dashboard
}

}
