% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ToxCrit.R
\name{ToxCrit}
\alias{ToxCrit}
\title{ToxCrit}
\usage{
ToxCrit(npat, ptoxcrit, pstop, nsim, ptox, a = 1, b = 1)
}
\arguments{
\item{npat}{number of patients to be included in the trial.}

\item{ptoxcrit}{critical (minimal unacceptable) toxicity rate (\%).}

\item{pstop}{critical posterior probability of unacceptable toxicity; higher values lead to
the termination of the trial/accrual.}

\item{nsim}{number of simulation runs (simulated studies).}

\item{ptox}{assumed true toxicity rate used for simulations (\%).}

\item{a}{first parameter of the Beta distribution.}

\item{b}{second parameter of the Beta distribution.}
}
\value{
A table containing information on critical boundaries per patient, the probability
 to stop the trial given the assumed true toxicity rate and the cumulative probability to stop
 the trial given the assumed true toxicity rate.
}
\description{
Calculates critical values for continuous monitoring of toxicity using a Bayesian approach. It also
simulates the probability for stopping the trial for each recruited patient given a true toxicity
rate passed in this function. \cr
To calculate the posterior distribution of the toxicity rate r, the binomial-beta model is used.
Thus, if y cases of toxicities have been observed among the first k patients, the posterior distribution
of r is beta(1+y, 1+k-y). The formal stopping criterion is reached if the posterior probability (Pr) that the
true toxicity rate r exceeds the unacceptable toxicity rate. \cr
Please note: The trial must be stopped or modified if the observed number of toxicities is >= the critical value for the respective number of recruited patients.
This method is mostly used for early phase clinical trials and validated
according to GCP. It was firstly presented at the 54th annual meeting of GMDS. \cr
Assumptions:\cr
1. The prior distribution of the toxicity rate is assumed to be beta(a,b).\cr
2. No stopping at the first patient.\cr
IMPORTANT INFORMATION:\cr
The program is closed automatically after each execution on a server.
Therefore, always the same pseudo random numbers are used and simulation based on the
the same parameters will always yield identical output!
In order to fix this, an additional random number is generated based on a time-dependent
seed point.
}
\examples{
 #Pr(r>30\%)>=95\%) --> The posterior probability that the true toxicity rate exceeds the
 #unacceptable toxicity rate of 30\% is at least 95\% (with 9 patients, an assumed true
 #toxicity rate of 20\% and 100,000 simulation runs):
 ToxCrit(9, 30, 95, 100000, 20)
}
