% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bond.R
\name{Bond-class}
\alias{Bond-class}
\alias{Bond}
\title{Bond Class}
\arguments{
\item{Notional}{The notional amount of the trade}

\item{MTM}{The mark-to-market valuation of the trade}

\item{Currency}{The currency set that the trade belongs to}

\item{Si}{The number of years that the trade will take to start (zero if already started)}

\item{BuySell}{Takes the values of either 'Buy' or 'Sell'}

\item{yield}{The yield of the Bond}

\item{ISIN}{The ISIN of the Bond,}

\item{payment_frequency}{the frequency that the bond pays coupon (Quarter, SA etc)}

\item{maturity_date}{the maturity date of the bond}

\item{coupon_type}{The coupon type of the bond (fixed, floating, flipper etc)}

\item{credit_risk_weight}{The percentage weight of the exposure of the bond that should be attributed to the 'Credit' asset class}

\item{Issuer}{The issuer of the bond}
}
\value{
An object of type Bond
}
\description{
Creates a Bond object with the relevant info needed to calculate the Exposure-at-Default (EAD)
}

\examples{

tr1 = Bond(Notional=10000,MtM=30,Currency="EUR",Si=0,maturity_date="2026-04-04",
BuySell='Buy',payment_frequency="SA",
credit_risk_weight=0.2,coupon_type="Fixed",Issuer="FirmA",ISIN = "XS0943423")
}
\author{
Tasos Grivas <tasos@openriskcalculator.com>
}
