% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalcUKThunderBallPnL.R
\name{CalcUKThunderBallPnL}
\alias{CalcUKThunderBallPnL}
\title{PnL calculation for UKThunderBall backtesting}
\usage{
CalcUKThunderBallPnL(backtested_results, plot_results = FALSE)
}
\arguments{
\item{backtested_results}{The UKThunderBall results backtested against the user input}

\item{plot_results}{(Optional) If TRUE, the P&L historical graphs are plotted, default FALSE}
}
\value{
PnL figures
}
\description{
Calculates the PnL for a pay out structure created during backtesting
}
\examples{

ukthunderball_results = UKThunderBallResults()
user_input = c(10,20,30,31,32,5)
backtested_results = UKThunderballBacktesting(ukthunderball_results, user_input = user_input)
pnl_result = CalcUKThunderBallPnL(backtested_results, plot_results = FALSE)
}
\author{
Tasos Grivas <tasos@openriskcalculator.com>
}
