% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TreeRingsInterpolation.R
\name{TreeRingsInterpolation}
\alias{TreeRingsInterpolation}
\title{Interpolates tree ring between representative (manual input) tree rings with tree ring points}
\usage{
TreeRingsInterpolation(TR)
}
\arguments{
\item{TR}{object  of classTreeRingShape (without tree ring interpolated)}
}
\value{
TR  object  of classTreeRingShape (with tree ring interpolated)
}
\description{
Interpolates tree ring between representative (manual input) tree rings with tree ring points
}
\examples{
# tree ring interpolation (add TR@L2 to classTreeRingShape )
TR@L2   ### empty
TR <- TreeRingsInterpolation(TR)
TR@L2  ###  entered
ya <- plot_year_RingArea(TR@L2, 2018)$Year_TreeRingArea
# Figure of relationships year and tree ring area
plot(ya,type='b')
tri. <- TreeRingIndex(ya)
lines(tri.$spline,col='red',lw=2)
# Figure of relationships year and tree ring index
plot(tri.$idx,type='b')
abline(h=1,col='red')

}
