% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biophysmodel_limpetBH.R
\name{Tb_limpetBH}
\alias{Tb_limpetBH}
\title{Operative Environmental Temperature of a Limpet Based on a Model by Helmuth}
\usage{
Tb_limpetBH(T_a, T_r, l, h, S, u, s_aspect, s_slope, c)
}
\arguments{
\item{T_a}{\code{numeric} air temperature (C).}

\item{T_r}{\code{numeric} rock surface temperature (C) in the sunlight.}

\item{l}{\code{numeric} limpet length (anterior/posterior axis) (m).}

\item{h}{\code{numeric} limpet height (dorsal/ventral axis) (m).}

\item{S}{\code{numeric} solar irradiance (\ifelse{html}{\out{W m<sup>-2</sup>}}{\eqn{W m^-2}{ASCII}}).}

\item{u}{\code{numeric} wind speed (\ifelse{html}{\out{m s<sup>-1</sup>}}{\eqn{m s^-1}{ASCII}}).}

\item{s_aspect}{\code{numeric} solar aspect angle (degree), the angle between the limpet's length dimension and the vector to the Sun. Generally between 70 and 110 degrees.}

\item{s_slope}{\code{numeric} solar elevation angle (degree), the altitude of the sun, which is the angle between the horizon and the sun.}

\item{c}{\code{numeric} fraction of the sky covered by clouds.}
}
\value{
\code{numeric} predicted body (operative environmental) temperature (C).
}
\description{
The function predicts body temperatures (C, operative environmental temperatures) of a limpet. The function was provided by Brian Helmuth -- although radiation and convection are altered from his original model -- and based on \insertCite{Denny2006;textual}{TrenchR}.
}
\details{
The original equation uses a finite-difference approach where they divide the rock into series of chunks, and calculate the temperature at each node to derive the conductive heat. For simplification, here it takes the rock temperature as a parameter, and conductive heat is calculated by the product of the area, thermal conductivity of rock and the difference in temperatures of the rock and the body.
  \cr \cr
  Limpets are simulated as cones following and using solar emissivity values from \insertCite{Campbell1998;textual}{TrenchR}.
  \cr \cr
  The area of the limpet's shell (\ifelse{html}{\out{m<sup>2</sup>}}{\eqn{m^2}{ASCII}}) is projected in the direction at which sunlight strikes the organism \insertCite{Pennell1989;textual}{TrenchR}.
  \cr \cr
  Air conductivity values (\ifelse{html}{\out{W m<sup>-1</sup> K<sup>-1</sup>}}{\eqn{W m^-1 K^-1}{ASCII}}) are calculated following \insertCite{Denny2006;textual}{TrenchR}.
}
\examples{
  Tb_limpetBH(T_a = 25,
              T_r = 30,
              l = 0.0176,
              h = 0.0122,
              S = 1300,
              u = 1,
              s_aspect = 90,
              s_slope = 60,
              c = 1)

}
\references{
\insertAllCited{}
}
\seealso{
Other biophysical models: 
\code{\link{Grashof_number_Gates}()},
\code{\link{Grashof_number}()},
\code{\link{Nusselt_from_Grashof}()},
\code{\link{Nusselt_from_Reynolds}()},
\code{\link{Nusselt_number}()},
\code{\link{Prandtl_number}()},
\code{\link{Qconduction_animal}()},
\code{\link{Qconduction_substrate}()},
\code{\link{Qconvection}()},
\code{\link{Qemitted_thermal_radiation}()},
\code{\link{Qevaporation}()},
\code{\link{Qmetabolism_from_mass_temp}()},
\code{\link{Qmetabolism_from_mass}()},
\code{\link{Qnet_Gates}()},
\code{\link{Qradiation_absorbed}()},
\code{\link{Qthermal_radiation_absorbed}()},
\code{\link{Reynolds_number}()},
\code{\link{T_sky}()},
\code{\link{Tb_CampbellNorman}()},
\code{\link{Tb_Gates2}()},
\code{\link{Tb_Gates}()},
\code{\link{Tb_butterfly}()},
\code{\link{Tb_grasshopper}()},
\code{\link{Tb_limpet}()},
\code{\link{Tb_lizard_Fei}()},
\code{\link{Tb_lizard}()},
\code{\link{Tb_mussel}()},
\code{\link{Tb_salamander_humid}()},
\code{\link{Tb_snail}()},
\code{\link{Tbed_mussel}()},
\code{\link{Tsoil}()},
\code{\link{actual_vapor_pressure}()},
\code{\link{boundary_layer_resistance}()},
\code{\link{external_resistance_to_water_vapor_transfer}()},
\code{\link{free_or_forced_convection}()},
\code{\link{heat_transfer_coefficient_approximation}()},
\code{\link{heat_transfer_coefficient_simple}()},
\code{\link{heat_transfer_coefficient}()},
\code{\link{saturation_vapor_pressure}()},
\code{\link{saturation_water_vapor_pressure}()}
}
\author{
Brian Helmuth et al.
}
\concept{biophysical models}
