% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/species_suitability.R
\name{species_suitability}
\alias{species_suitability}
\title{Calculate species suitability}
\usage{
species_suitability(
  Rastercurrent,
  species_names,
  name = "Problem",
  verbose = FALSE
)
}
\arguments{
\item{Rastercurrent}{raster object of current suitability}

\item{species_names}{character vector of species names}

\item{name}{The name of the output file}

\item{verbose}{Logical whether messages will be written while the
function is generating calculations, defaults to FALSE}
}
\value{
.dat file. This function is used for the side-effect of writing values to a file.
}
\description{
Calculate species suitability from a given raster and species names and writes them to a .dat file. The file
will be written to the location specified by the \code{name} argument. If the file
already exists, it will be overwritten. The file format is plain text, with each
line terminated by a newline character.
}
\examples{
library(terra)
data(Current)
Current <- terra::unwrap(Current)
species_suitability(Rastercurrent = Current, species_names = c("Spp1", "Spp2", "Spp3", "Spp4"))

file.remove("Problem.dat")
}
