% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{.cholpermGGE}
\alias{.cholpermGGE}
\title{Cholesky matrix decomposition with GGE ordering}
\usage{
.cholpermGGE(Sigma, l, u)
}
\arguments{
\item{Sigma}{\code{d} by \code{d} covariance matrix}

\item{l}{\code{d} vector of lower bounds}

\item{u}{\code{d} vector of upper bounds}
}
\value{
a list with components
\itemize{
\item \code{L}: Cholesky root
\item \code{l}: permuted vector of lower bounds
\item \code{u}: permuted vector of upper bounds
\item \code{perm}: vector of integers with ordering of permutation
}
}
\description{
This function computes the Cholesky decomposition of a covariance matrix
\code{Sigma} and returns a list containing the permuted bounds for integration. 
The prioritization of the variables follow the rule proposed in Gibson, Glasbey and Elston (1994)
and reorder variables to have outermost variables with smallest expected values.
}
\details{
The list contains an integer vector \code{perm} with the indices of the permutation, which is such that
\code{Sigma(perm, perm) == L \%*\% t(L)}.
The permutation scheme is described in Genz and Bretz (2009) in Section 4.1.3, p.37.
}
\references{
Genz, A. and Bretz, F. (2009). Computations of Multivariate Normal and t Probabilities, volume 105. Springer, Dordrecht.

Gibson G.J., Glasbey C.A. and D.A. Elton (1994).  Monte Carlo evaluation of multivariate normal integrals and sensitivity to variate ordering. In: Dimon et al., Advances in Numerical Methods and Applications, WSP, pp. 120-126.
}
\keyword{internal}
